/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.nbf;

import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NBFSchemaParser {
    private static final Logger log = LogManager.getLogger(NBFSchemaParser.class);
    private String bufferName;
    private Map<String, String> flds = new HashMap<String, String>();

    private void findElementType(XSComplexType xtype) {
        XSTerm term;
        XSContentType xsContentType = xtype.getContentType();
        XSParticle particle = xsContentType.asParticle();
        if (particle != null && (term = particle.getTerm()).isModelGroup()) {
            XSParticle[] particles;
            XSModelGroup xsModelGroup = term.asModelGroup();
            block0: for (XSParticle p : particles = xsModelGroup.getChildren()) {
                XSTerm pterm = p.getTerm();
                if (!pterm.isElementDecl()) continue;
                XSElementDecl element = pterm.asElementDecl();
                String name = element.getName();
                log.debug((Object)name);
                for (XSType type = element.getType(); type != null; type = type.getBaseType()) {
                    String typeName = type.getName();
                    if (typeName == null || !typeName.equals("long") && !typeName.equals("string") && !typeName.equals("integer") && !typeName.equals("float") && !typeName.endsWith("_type")) continue;
                    log.debug((Object)typeName);
                    this.flds.put(name, typeName);
                    continue block0;
                }
            }
        }
    }

    public boolean parse(String fname) {
        boolean rc = false;
        try {
            this.flds.clear();
            XSOMParser parser = new XSOMParser();
            parser.parse(fname);
            XSSchemaSet xsSchema = parser.getResult();
            XSSchema schema = xsSchema.getSchema(1);
            File file = new File(fname);
            XSElementDecl element = schema.getElementDecl(file.getName().replace(".xsd", ""));
            if (element != null) {
                log.debug((Object)("element is " + element.getName()));
                this.bufferName = element.getName();
                XSType xtype = element.getType();
                if (xtype.isComplexType()) {
                    this.findElementType(xtype.asComplexType());
                    rc = true;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("parse " + fname + " failed with " + e.getMessage()), (Throwable)e);
        }
        return rc;
    }

    public String getBufferName() {
        return this.bufferName;
    }

    public Map<String, String> getFileds() {
        return this.flds;
    }
}

