/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.xatmi.impl;

import java.io.File;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.nbf.NBFParser;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.BT_NBF;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.BufferImpl;

public class BT_NBF_Impl
extends BufferImpl
implements BT_NBF {
    private static final Logger log = LogManager.getLogger(BT_NBF_Impl.class);
    private static final long serialVersionUID = 1L;
    private NBFParser parser;
    private String rootElement;

    public BT_NBF_Impl(String subtype) throws ConfigurationException, ConnectionException {
        super("BT_NBF", subtype, false, null);
        this.rootElement = "</" + subtype + ">";
        String xsd = "buffers/" + subtype + ".xsd";
        File file = new File(xsd);
        if (!file.exists()) {
            throw new ConfigurationException("can not find " + xsd);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>");
        buffer.append("<");
        buffer.append(subtype);
        buffer.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        buffer.append(" xmlns=\"http://www.jboss.org/blacktie\"");
        buffer.append(" xsi:schemaLocation=\"http://www.jboss.org/blacktie buffers/");
        buffer.append(subtype);
        buffer.append(".xsd\">");
        buffer.append("</");
        buffer.append(subtype);
        buffer.append(">");
        this.setRawData(buffer.toString().getBytes());
        this.parser = new NBFParser(xsd);
        this.parser.parse(this.getRawData());
    }

    private String insertString(String buffer, String attr) {
        int k = buffer.indexOf(this.rootElement);
        return buffer.substring(0, k) + attr + buffer.substring(k);
    }

    public boolean btaddattribute(String attrId, Object attrValue) {
        boolean rc = false;
        try {
            this.parser.setId(attrId);
            String buffer = new String(this.getRawData());
            String attr = "<" + attrId + "></" + attrId + ">";
            String newbuffer = this.insertString(buffer, attr);
            rc = this.parser.parse(newbuffer.getBytes());
            if (rc) {
                String newattr;
                String attrbuf;
                String type = this.parser.getType();
                StringBuffer buf = new StringBuffer();
                if (type.equals("long")) {
                    buf.append((Long)attrValue);
                } else if (type.equals("string")) {
                    buf.append((String)attrValue);
                } else if (type.equals("integer")) {
                    buf.append((Integer)attrValue);
                } else if (type.equals("short")) {
                    buf.append((Short)attrValue);
                } else if (type.equals("float")) {
                    buf.append((Float)attrValue);
                } else if (type.endsWith("_type")) {
                    String nbf = new String(((BT_NBF_Impl)attrValue).getRawData());
                    int k = nbf.indexOf(".xsd\">");
                    int size = nbf.length();
                    String test = nbf.substring(k + 6, size - attrId.length() - 3);
                    buf.append(test);
                } else {
                    log.error((Object)("Can not support type " + type));
                    rc = false;
                }
                if (buf.length() > 0 && (rc = this.parser.parse((attrbuf = this.insertString(buffer, newattr = "<" + attrId + ">" + buf + "</" + attrId + ">")).getBytes()))) {
                    this.setRawData(attrbuf.getBytes());
                }
            }
        }
        catch (ClassCastException e) {
            rc = false;
            log.warn((Object)("type is " + this.parser.getType() + " but attrValue type is " + attrValue.getClass().getName()));
        }
        catch (Throwable e) {
            log.error((Object)("btaddattribute failed with " + e.getMessage()));
        }
        return rc;
    }

    public Object btgetattribute(String attrId, int index) {
        Object toReturn = null;
        try {
            boolean rc = false;
            this.parser.setId(attrId);
            this.parser.setIndex(index);
            rc = this.parser.parse(this.getRawData());
            if (rc) {
                String type = this.parser.getType();
                String value = this.parser.getValue();
                log.debug((Object)("vlaue is " + value));
                if (value == null) {
                    log.warn((Object)("can not find " + attrId + " at index " + index));
                } else {
                    String tmp = new String(this.getRawData());
                    int pos = this.find_element_string(tmp, attrId, index, false);
                    if (pos == -1) {
                        log.warn((Object)(attrId + " at index " + index + " has been deleted"));
                        return null;
                    }
                    if (type.equals("long")) {
                        toReturn = Long.parseLong(value);
                    } else if (type.equals("string")) {
                        toReturn = value;
                    } else if (type.equals("integer")) {
                        toReturn = Integer.parseInt(value);
                    } else if (type.equals("short")) {
                        toReturn = Short.parseShort(value);
                    } else if (type.equals("float")) {
                        toReturn = Float.valueOf(Float.parseFloat(value));
                    } else if (type.endsWith("_type")) {
                        toReturn = new BT_NBF_Impl(attrId);
                        String nbf = new String(((BT_NBF_Impl)toReturn).getRawData());
                        int k = nbf.indexOf(".xsd\">") + 6;
                        int size = nbf.length();
                        String buf = nbf.substring(0, k) + value + nbf.substring(k, size);
                        ((BT_NBF_Impl)toReturn).setRawData(buf.getBytes());
                    } else {
                        log.error((Object)("Can not support type " + type));
                    }
                }
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)("ConfigurationException: btgetattribute failed with " + e.getMessage()));
        }
        catch (ConnectionException e) {
            log.error((Object)("ConnectionException: btgetattribute failed with " + e.getMessage()));
        }
        return toReturn;
    }

    public boolean btdelattribute(String attrId, int index) {
        boolean toReturn = false;
        try {
            this.parser.setId(attrId);
            this.parser.setIndex(index);
            boolean rc = this.parser.parse(this.getRawData());
            if (rc) {
                String value = this.parser.getValue();
                if (value == null) {
                    log.warn((Object)("can not find " + attrId + " at index " + index));
                } else {
                    String buf = new String(this.getRawData());
                    int pos = this.find_element_string(buf, attrId, index, false);
                    if (pos > 0) {
                        int size = buf.length();
                        buf = buf.substring(0, pos + attrId.length() + 2) + buf.substring(pos + attrId.length() + 2 + value.length(), size);
                        log.debug((Object)buf);
                        this.setRawData(buf.getBytes());
                        toReturn = true;
                    }
                }
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)("btdelattribute failed with " + e.getMessage()));
        }
        return toReturn;
    }

    public boolean btsetattribute(String attrId, int index, Object newValue) {
        boolean rc = false;
        try {
            this.parser.setId(attrId);
            this.parser.setIndex(index);
            rc = this.parser.parse(this.getRawData());
            String value = this.parser.getValue();
            String buf = new String(this.getRawData());
            int pos = this.find_element_string(buf, attrId, index, true);
            if (value == null && pos == -1) {
                log.warn((Object)("can not find " + attrId + " at index " + index));
                rc = false;
            } else {
                String type = this.parser.getType();
                StringBuffer tmp = new StringBuffer();
                if (type.equals("long")) {
                    tmp.append((Long)newValue);
                } else if (type.equals("string")) {
                    tmp.append((String)newValue);
                } else if (type.equals("integer")) {
                    tmp.append((Integer)newValue);
                } else if (type.equals("short")) {
                    tmp.append((Short)newValue);
                } else if (type.equals("float")) {
                    tmp.append((Float)newValue);
                } else if (type.endsWith("_type")) {
                    String nbf = new String(((BT_NBF_Impl)newValue).getRawData());
                    int k = nbf.indexOf(".xsd\">");
                    int size = nbf.length();
                    String test = nbf.substring(k + 6, size - attrId.length() - 3);
                    tmp.append(test);
                } else {
                    log.error((Object)("Can not support type " + type));
                    rc = false;
                }
                if (rc) {
                    int size = buf.length();
                    char ch = buf.charAt(pos + attrId.length() + 3);
                    int length = ch == '/' ? 0 : value.length();
                    buf = buf.substring(0, pos + attrId.length() + 2) + tmp.toString() + buf.substring(pos + attrId.length() + 2 + length, size);
                    this.setRawData(buf.getBytes());
                }
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)("btsetattribute failed with " + e.getMessage()));
            rc = false;
        }
        catch (ClassCastException e) {
            rc = false;
            log.warn((Object)("type is " + this.parser.getType() + " but newValue type is " + newValue.getClass().getName()));
        }
        return rc;
    }

    private int find_element_string(String buf, String id, int index, boolean isset) {
        int pos = -1;
        String element = "<" + id + ">";
        int fromIndex = 0;
        for (int i = 0; i <= index; ++i) {
            pos = buf.indexOf(element, fromIndex);
            if (pos <= 0) continue;
            fromIndex = pos + element.length();
        }
        char ch = buf.charAt(pos + id.length() + 3);
        if (!isset && ch == '/') {
            pos = -1;
        }
        return pos;
    }

    public int getLen() {
        return this.getRawData().length;
    }

    public String toString() {
        return new String(this.getRawData());
    }
}

