/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.nbf;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.apache.xerces.xs.XSTypeDefinition;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NBFHandlers
extends DefaultHandler {
    private static final Logger log = LogManager.getLogger(NBFHandlers.class);
    private PSVIProvider provider;
    private String id;
    private String type;
    private String value;
    private String other_value;
    private int index;
    private int curIndex;
    private boolean found;

    public NBFHandlers(PSVIProvider provider) {
        this.provider = provider;
        this.curIndex = 0;
        this.value = null;
        this.found = false;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        if (this.type.endsWith("_type")) {
            return this.other_value;
        }
        return this.value;
    }

    public void setId(String id) {
        this.id = id;
        this.value = null;
    }

    public void setIndex(int index) {
        this.curIndex = 0;
        this.index = index;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.found) {
            String strValue = new String(ch, start, length);
            this.value = this.value == null ? strValue : this.value + strValue;
            log.debug((Object)("index = " + this.index + " curIndex = " + this.curIndex + " value = " + this.value));
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals(this.id)) {
            if (this.index == this.curIndex) {
                this.found = true;
            }
            ++this.curIndex;
            ElementPSVI psvi = this.provider.getElementPSVI();
            if (psvi != null) {
                for (XSTypeDefinition typeInfo = psvi.getTypeDefinition(); typeInfo != null; typeInfo = typeInfo.getBaseType()) {
                    String typeName = typeInfo.getName();
                    if (typeName == null || !typeName.equals("long") && !typeName.equals("string") && !typeName.equals("integer") && !typeName.equals("float") && !typeName.endsWith("_type")) continue;
                    this.type = typeName;
                    log.debug((Object)(qName + " has type of " + this.type));
                    break;
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(this.id)) {
            this.found = false;
        }
        if (this.found && this.type != null && this.type.endsWith("_type") && this.value != null) {
            String tmp = "<" + qName + ">" + this.value + "</" + qName + ">";
            this.other_value = this.other_value == null ? tmp : this.other_value + tmp;
            this.value = null;
        }
    }
}

