/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.btadmin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.administration.BlacktieAdministration;
import org.jboss.narayana.blacktie.btadmin.Command;
import org.jboss.narayana.blacktie.btadmin.CommandFailedException;
import org.jboss.narayana.blacktie.btadmin.IncompatibleArgsException;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.XMLParser;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Buffer;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Connection;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionFactory;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Response;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.X_OCTET;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CommandHandler
implements InvocationHandler {
    private static Logger log = LogManager.getLogger(CommandHandler.class);
    private Properties prop = new Properties();
    private Connection connection;
    private BlacktieAdministration administrationProxy;

    public CommandHandler() throws ConfigurationException, MalformedObjectNameException, NullPointerException {
        XMLParser.loadProperties((String)"btconfig.xsd", (String)"btconfig.xml", (Properties)this.prop);
        this.administrationProxy = (BlacktieAdministration)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{BlacktieAdministration.class}, (InvocationHandler)this);
    }

    public int handleCommand(String[] args) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        int exitStatus = -1;
        if (args.length < 1 || args[0] == null || args[0].trim().length() == 0) {
            log.error((Object)"No command was provided");
        } else {
            Command command = CommandHandler.loadCommand(args[0]);
            String[] commandArgs = new String[args.length - 1];
            if (commandArgs.length > 0) {
                log.trace((Object)"Copying arguments for the command");
                System.arraycopy(args, 1, commandArgs, 0, commandArgs.length);
            }
            String quickstartUsage = command.getQuickstartUsage();
            char[] charArray = quickstartUsage.toCharArray();
            int expectedArgsLength = 0;
            int optionalArgs = 0;
            for (int i = 0; i < quickstartUsage.length(); ++i) {
                if (charArray[i] == ' ') {
                    ++expectedArgsLength;
                    continue;
                }
                if (charArray[i] != '[') continue;
                ++optionalArgs;
            }
            if (charArray.length > 0) {
                ++expectedArgsLength;
            }
            if (commandArgs.length > expectedArgsLength || commandArgs.length < expectedArgsLength - optionalArgs) {
                if (optionalArgs == 0) {
                    log.trace((Object)("Arguments incompatible, expected " + expectedArgsLength + ", received: " + commandArgs.length));
                } else {
                    log.trace((Object)("Arguments incompatible, expected at least " + optionalArgs + " and no more than " + expectedArgsLength + ", received: " + commandArgs.length));
                }
                log.error((Object)("Expected Usage: " + args[0] + " " + quickstartUsage).trim());
            } else {
                try {
                    command.initializeArgs(commandArgs);
                    log.trace((Object)"Arguments initialized");
                    try {
                        command.invoke(this.administrationProxy, this.prop);
                        exitStatus = 0;
                        log.trace((Object)"Command invoked");
                    }
                    catch (CommandFailedException e) {
                        exitStatus = e.getExitCode();
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not invoke the command: " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (IncompatibleArgsException e) {
                    String usage = "Expected Usage: " + args[0] + " " + quickstartUsage;
                    log.error((Object)("Arguments invalid: " + e.getMessage()));
                    log.error((Object)usage.trim());
                    log.trace((Object)("Arguments invalid: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return exitStatus;
    }

    public static Command loadCommand(String commandName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String firstLetter = commandName.substring(0, 1);
        String remainder = commandName.substring(1);
        String capitalized = firstLetter.toUpperCase() + remainder;
        String className = "org.jboss.narayana.blacktie.btadmin.commands." + capitalized;
        log.debug((Object)("Will execute the " + className + " command"));
        Command command = (Command)Class.forName(className).newInstance();
        log.debug((Object)"Command was known");
        return command;
    }

    public static String convertList(String operationName, List list) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Output from: " + operationName);
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            buffer.append("\nElement: " + i + " Value: " + iterator.next());
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws ConfigurationException, ConnectionException, CommandFailedException, ParserConfigurationException, SAXException, IOException {
        if (this.connection == null) {
            ConnectionFactory cf = ConnectionFactory.getConnectionFactory();
            this.connection = cf.getConnection();
        }
        StringBuffer command = new StringBuffer(method.getName());
        command.append(',');
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) {
                    args[i] = "";
                }
                command.append(args[i].toString());
                command.append(',');
            }
        }
        X_OCTET sendbuf = (X_OCTET)this.connection.tpalloc("X_OCTET", null);
        sendbuf.setByteArray(command.toString().getBytes());
        Response received = this.connection.tpcall("BTDomainAdmin", (Buffer)sendbuf, 0);
        X_OCTET rcvbuf = (X_OCTET)received.getBuffer();
        Class<?> returnType = method.getReturnType();
        byte[] byteArray = rcvbuf.getByteArray();
        if (returnType == Boolean.class) {
            if (byteArray[0] == 1) {
                return true;
            }
            return false;
        }
        if (returnType == Long.class) {
            return this.convertLong(byteArray);
        }
        if (returnType == String.class) {
            return new String(byteArray);
        }
        if (returnType == List.class) {
            String listTerminator = "|";
            String string = new String(byteArray);
            StringTokenizer outParameters = new StringTokenizer(string, ",", false);
            if (!method.getName().equals("listRunningInstanceIds")) {
                ArrayList<String> toReturn = new ArrayList<String>();
                while (outParameters.hasMoreTokens()) {
                    String nextToken = outParameters.nextToken();
                    if (nextToken.equals(listTerminator)) continue;
                    toReturn.add(nextToken);
                }
                return toReturn;
            }
            ArrayList<Integer> toReturn = new ArrayList<Integer>();
            while (outParameters.hasMoreTokens()) {
                String nextToken = outParameters.nextToken();
                if (nextToken.equals(listTerminator)) continue;
                toReturn.add(Integer.parseInt(nextToken));
            }
            return toReturn;
        }
        if (returnType == Element.class) {
            StringReader sreader = new StringReader(new String(byteArray));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(new InputSource(sreader));
            return doc.getDocumentElement();
        }
        log.error((Object)("Could not handle response type: " + returnType));
        throw new CommandFailedException(-1);
    }

    private long convertLong(byte[] response) throws IOException {
        ByteArrayInputStream baos = new ByteArrayInputStream(response);
        DataInputStream dos = new DataInputStream(baos);
        ByteBuffer bbuf = ByteBuffer.allocate(8);
        bbuf.order(ByteOrder.BIG_ENDIAN);
        bbuf.put(response);
        bbuf.order(ByteOrder.LITTLE_ENDIAN);
        return bbuf.getLong(0);
    }
}

