/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.btadmin.commands;

import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.administration.BlacktieAdministration;
import org.jboss.narayana.blacktie.btadmin.Command;
import org.jboss.narayana.blacktie.btadmin.CommandFailedException;
import org.jboss.narayana.blacktie.btadmin.IncompatibleArgsException;

public class ListServiceStatus
implements Command {
    private static Logger log = LogManager.getLogger(ListServiceStatus.class);
    private String serverName;
    private String serviceName;

    @Override
    public String getQuickstartUsage() {
        return "<serverName> <serviceName>";
    }

    @Override
    public void initializeArgs(String[] args) throws IncompatibleArgsException {
        this.serverName = args[0];
        this.serviceName = args[1];
    }

    @Override
    public void invoke(BlacktieAdministration connection, Properties configuration) throws CommandFailedException {
        String status = connection.listServiceStatus(this.serverName, this.serviceName);
        if (status == null) {
            log.error((Object)("Server/service was not running: " + this.serverName + "/" + this.serviceName));
            throw new CommandFailedException(-1);
        }
        log.info((Object)status);
    }
}

