/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.btadmin.commands;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.administration.BlacktieAdministration;
import org.jboss.narayana.blacktie.btadmin.Command;
import org.jboss.narayana.blacktie.btadmin.CommandFailedException;
import org.jboss.narayana.blacktie.btadmin.IncompatibleArgsException;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.Machine;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.Server;

public class Shutdown
implements Command {
    private static Logger log = LogManager.getLogger(Shutdown.class);
    private String serverName;
    private int id = 0;
    private static String OS = System.getProperty("os.name").toLowerCase();
    private int checkPeriodMillis = 2000;
    private int numChecks = 10;

    @Override
    public String getQuickstartUsage() {
        return "[<serverName> [<serverId>]]";
    }

    @Override
    public void initializeArgs(String[] args) throws IncompatibleArgsException {
        if (args.length > 0) {
            this.serverName = args[0];
            if (args.length == 2) {
                try {
                    this.id = Integer.parseInt(args[1]);
                    log.trace((Object)("Successfully parsed: " + args[1]));
                }
                catch (NumberFormatException nfe) {
                    throw new IncompatibleArgsException("The third argument was expected to be the (integer) instance id to shutdown");
                }
            }
        }
    }

    @Override
    public void invoke(BlacktieAdministration connection, Properties configuration) throws CommandFailedException {
        ArrayList<ServerToStop> serversToStop = new ArrayList<ServerToStop>();
        List serverLaunchers = (List)configuration.get("blacktie.domain.serverLaunchers");
        if (this.serverName == null) {
            for (Server server : serverLaunchers) {
                Iterator iterator2;
                try {
                    iterator2 = server.getLocalMachine().iterator();
                }
                catch (UnknownHostException e) {
                    log.error((Object)"Could not get the local machine");
                    throw new CommandFailedException(-1);
                }
                while (iterator2.hasNext()) {
                    Machine machine = (Machine)iterator2.next();
                    ServerToStop serverToStop = new ServerToStop();
                    serverToStop.setName(server.getName());
                    serverToStop.setId(machine.getServerId());
                    serversToStop.add(serverToStop);
                }
            }
        } else {
            ServerToStop serverToStop = new ServerToStop();
            serverToStop.setName(this.serverName);
            serverToStop.setId(this.id);
            serversToStop.add(serverToStop);
        }
        if (serversToStop.size() != 0) {
            for (ServerToStop next : serversToStop) {
                String name = next.getName();
                int id = next.getId();
                Boolean result = connection.shutdown(name, id);
                boolean shutdown = false;
                if (result.booleanValue()) {
                    log.info((Object)("Server shutdown successfully: " + name + " with id: " + id));
                    log.info((Object)("waiting for " + name + ":" + id + " shutdown complete"));
                    for (int i = 0; i < this.numChecks; ++i) {
                        if (!this.checkServerAlive(name, id)) {
                            log.info((Object)(name + ":" + id + " shutdown complete"));
                            shutdown = true;
                            break;
                        }
                        try {
                            Thread.sleep(this.checkPeriodMillis);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        log.info((Object)(name + ":" + id + " is still alive, sleeping for a further " + this.checkPeriodMillis + "ms"));
                    }
                    if (shutdown) continue;
                    log.error((Object)(name + ":" + id + " has not shutdown complete"));
                    throw new CommandFailedException(-1);
                }
                log.error((Object)"Server could not be shutdown (may already be stopped)");
                throw new CommandFailedException(-1);
            }
        } else {
            log.error((Object)"No servers were configured for shutdown");
            throw new CommandFailedException(-1);
        }
    }

    private boolean checkServerAlive(String name, int id) {
        String cmd = null;
        ProcessBuilder pb = null;
        boolean toReturn = false;
        if (OS.indexOf("linux") >= 0) {
            log.debug((Object)(OS + " check for linux"));
            cmd = id != 0 ? "ps -ef | grep \"\\\\-i " + id + " \\\\-s " + name + "\" | grep -v grep" : "ps -ef | grep \"\\\\-s " + name + "\" | grep -v grep";
            log.debug((Object)cmd);
            pb = new ProcessBuilder("/bin/sh", "-c", cmd);
        } else if (OS.indexOf("win") >= 0) {
            log.debug((Object)(OS + " check for windows "));
            cmd = id != 0 ? "wmic process get commandline | findstr /c:\"\\-i " + id + " \\-s " + name + "\" | findstr /v findstr" : "wmic process get commandline | findstr /c:\"\\-s " + name + "\" | findstr /v findstr";
            log.debug((Object)cmd);
            pb = new ProcessBuilder("cmd", "/c", cmd);
        } else {
            log.warn((Object)(OS + " no check"));
            return false;
        }
        try {
            Process p = pb.start();
            if (OS.indexOf("win") >= 0) {
                p.getOutputStream().close();
            }
            p.waitFor();
            if (p.exitValue() == 0) {
                log.debug((Object)("check cmd " + cmd + " output"));
                InputStream is = p.getInputStream();
                BufferedReader ein = new BufferedReader(new InputStreamReader(is));
                String res = ein.readLine();
                if (res != null) {
                    log.debug((Object)("cmd " + cmd + " output: " + res));
                    toReturn = true;
                }
                is.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("run " + cmd + " failed with " + e));
        }
        return toReturn;
    }

    private class ServerToStop {
        private String name;
        private int id;

        private ServerToStop() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

