/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.btadmin.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.administration.BlacktieAdministration;
import org.jboss.narayana.blacktie.btadmin.Command;
import org.jboss.narayana.blacktie.btadmin.CommandFailedException;
import org.jboss.narayana.blacktie.btadmin.IncompatibleArgsException;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.Machine;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.Server;

public class Startup
implements Command {
    private static Logger log = LogManager.getLogger(Startup.class);
    private String serverName;

    @Override
    public String getQuickstartUsage() {
        return "[<serverName>]";
    }

    @Override
    public void initializeArgs(String[] args) throws IncompatibleArgsException {
        if (args.length == 1) {
            this.serverName = args[0];
        }
    }

    @Override
    public void invoke(BlacktieAdministration connection, Properties configuration) throws CommandFailedException {
        List serverLaunchers = (List)configuration.get("blacktie.domain.serverLaunchers");
        boolean found = false;
        for (Server next : serverLaunchers) {
            List localMachinesList;
            if (this.serverName != null && !this.serverName.equals(next.getName())) continue;
            if (this.serverName != null) {
                log.debug((Object)("Listing machines for: " + this.serverName));
            } else {
                log.debug((Object)"Listing machines");
            }
            try {
                localMachinesList = next.getLocalMachine();
            }
            catch (UnknownHostException e) {
                log.error((Object)"Could not get the local machine");
                throw new CommandFailedException(-1);
            }
            if (localMachinesList.size() == 0) continue;
            Iterator localMachines = localMachinesList.iterator();
            while (localMachines.hasNext()) {
                log.debug((Object)"Found machine");
                Machine localMachine = (Machine)localMachines.next();
                String pathToExecutable = localMachine.getPathToExecutable();
                String argLine = "-i " + localMachine.getServerId() + " -s " + localMachine.getServer().getName();
                if (localMachine.getArgLine() != null) {
                    argLine = argLine + " " + localMachine.getArgLine();
                }
                String[] split = argLine.split("[ ]+");
                String[] cmdarray = new String[split.length + 1 + 0];
                cmdarray[0] = pathToExecutable;
                System.arraycopy(split, 0, cmdarray, 1, split.length);
                String[] envp = null;
                File dir = new File(localMachine.getWorkingDirectory());
                try {
                    String readLine;
                    Process exec = Runtime.getRuntime().exec(cmdarray, envp, dir);
                    log.debug((Object)("Launched server: " + pathToExecutable));
                    BufferedReader output = new BufferedReader(new InputStreamReader(exec.getInputStream()));
                    BufferedReader error = new BufferedReader(new InputStreamReader(exec.getErrorStream()));
                    do {
                        if ((readLine = output.readLine()) == null) {
                            readLine = error.readLine();
                        }
                        log.info((Object)readLine);
                        if (readLine == null) {
                            throw new CommandFailedException(-3);
                        }
                        if (!readLine.endsWith("serverinit failed")) continue;
                        throw new CommandFailedException(-2);
                    } while (!readLine.endsWith("Server waiting for requests..."));
                    new Thread(new EatIO(exec.getInputStream())).start();
                    new Thread(new EatIO(exec.getErrorStream())).start();
                    found = true;
                }
                catch (IOException e) {
                    log.error((Object)"Could not launch the server", (Throwable)e);
                    throw new CommandFailedException(-1);
                }
            }
        }
        if (!found) {
            log.error((Object)"No machines configured for host");
            throw new CommandFailedException(-1);
        }
    }

    private class EatIO
    implements Runnable {
        private InputStream is;

        public EatIO(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            byte[] buf = new byte[1024];
            try {
                int len;
                while ((len = this.is.read(buf)) > 0) {
                }
            }
            catch (IOException e) {
                log.error((Object)"Could not write output");
            }
        }
    }
}

