/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateTransaction;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinateXidImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TransactionImporter;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionImple;
import jakarta.transaction.SystemException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.ImportedTransaction;
import org.jboss.tm.TransactionImportResult;

public class TransactionImporterImple
implements TransactionImporter {
    private static ConcurrentHashMap<Xid, AtomicReference<SubordinateTransaction>> _transactions = new ConcurrentHashMap();

    public SubordinateTransaction importTransaction(Xid xid) throws XAException {
        return (SubordinateTransaction)this.importRemoteTransaction(xid, 0).getTransaction();
    }

    public SubordinateTransaction importTransaction(Xid xid, int timeout) throws XAException {
        return (SubordinateTransaction)this.importRemoteTransaction(xid, timeout).getTransaction();
    }

    public TransactionImportResult importRemoteTransaction(Xid xid, int timeout) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        return this.addImportedTransaction(null, (Xid)new SubordinateXidImple(xid), xid, timeout);
    }

    public SubordinateTransaction recoverTransaction(Uid actId) throws XAException {
        if (actId == null) {
            throw new IllegalArgumentException();
        }
        com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.TransactionImple recovered = new com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.TransactionImple(actId);
        if (recovered.baseXid() == null) {
            throw new IllegalArgumentException();
        }
        return (SubordinateTransaction)this.addImportedTransaction(recovered, recovered.baseXid(), null, 0).getTransaction();
    }

    public SubordinateTransaction getImportedTransaction(Xid xid) throws XAException {
        SubordinateTransaction tx;
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        AtomicReference<SubordinateTransaction> holder = _transactions.get(new SubordinateXidImple(xid));
        SubordinateTransaction subordinateTransaction = tx = holder == null ? null : holder.get();
        if (tx == null) {
            return null;
        }
        try {
            if (tx.getStatus() == 4) {
                throw new XAException(100);
            }
        }
        catch (SystemException e) {
            throw new XAException(100);
        }
        if (tx.baseXid() == null) {
            tx.recover();
            return tx;
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImportedTransaction(Xid xid) throws XAException {
        if (xid == null) {
            throw new IllegalArgumentException();
        }
        AtomicReference<SubordinateTransaction> remove = _transactions.remove(new SubordinateXidImple(xid));
        if (remove != null) {
            AtomicReference<SubordinateTransaction> atomicReference = remove;
            synchronized (atomicReference) {
                TransactionImple transactionImple = (TransactionImple)remove.get();
                while (transactionImple == null) {
                    try {
                        remove.wait();
                        transactionImple = (TransactionImple)remove.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new XAException(-7);
                    }
                }
                com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.TransactionImple.removeTransaction(transactionImple);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionImportResult addImportedTransaction(com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.TransactionImple recoveredTransaction, Xid mapKey, Xid xid, int timeout) {
        AtomicReference<SubordinateTransaction> atomicReference;
        boolean isNew = false;
        SubordinateXidImple importedXid = new SubordinateXidImple(mapKey);
        AtomicReference<SubordinateTransaction> holder = new AtomicReference<SubordinateTransaction>();
        AtomicReference existing = _transactions.putIfAbsent((Xid)importedXid, holder);
        if (existing != null) {
            holder = existing;
        }
        SubordinateTransaction txn = (SubordinateTransaction)holder.get();
        if (recoveredTransaction != null) {
            atomicReference = holder;
            synchronized (atomicReference) {
                recoveredTransaction.recordTransaction();
                txn = recoveredTransaction;
                holder.set(txn);
                holder.notifyAll();
            }
        }
        if (txn == null) {
            atomicReference = holder;
            synchronized (atomicReference) {
                txn = (SubordinateTransaction)holder.get();
                if (txn == null) {
                    txn = new com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.TransactionImple(timeout, xid);
                    holder.set(txn);
                    holder.notifyAll();
                    isNew = true;
                }
            }
        }
        return new TransactionImportResult((ImportedTransaction)txn, isNew);
    }
}

