/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.helper;

import java.io.File;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;

public class JmxConnectionHelper {
    public static final String CONNECTOR_DESCRIPTOR_TYPE = "connectorDescriptorType";
    public static final String CONNECTOR_ADDRESS = "connectorAddress";
    public static final String CONNECTOR_PRINCIPAL = "connectorPrincipal";
    public static final String CONNECTOR_CREDENTIALS = "connectorCredentials";
    public static final String JBOSS_HOME_DIR = "jbossHomeDir";
    private static final Log log = LogFactory.getLog(JmxConnectionHelper.class);
    private static EmsConnection connection;
    private static Configuration configuration;
    private static final String JNP_DISABLE_DISCOVERY_JNP_INIT_PROP = "jnp.disableDiscovery";
    private static final int JNP_TIMEOUT = 30000;
    private static final int JNP_SO_TIMEOUT = 15000;
    private static int consecutiveConnectionErrors;
    private boolean copyConnectionLibraries;
    private File tmpDir;

    public JmxConnectionHelper(boolean copyConnectionLibraries, File tmpDir) {
        this.copyConnectionLibraries = copyConnectionLibraries;
        this.tmpDir = tmpDir;
    }

    public EmsConnection getEmsConnection(Configuration config) {
        EmsConnection emsConnection = null;
        configuration = config;
        try {
            emsConnection = JmxConnectionHelper.loadConnection(config, this.copyConnectionLibraries, this.tmpDir);
        }
        catch (Exception e) {
            log.error((Object)"Component attempting to access a connection that could not be loaded");
        }
        return emsConnection;
    }

    public EmsConnection getEmsConnection() {
        EmsConnection emsConnection = null;
        if (configuration == null) {
            throw new RuntimeException("No configuration set");
        }
        try {
            emsConnection = JmxConnectionHelper.loadConnection(configuration, this.copyConnectionLibraries, this.tmpDir);
        }
        catch (Exception e) {
            log.error((Object)"Component attempting to access a connection that could not be loaded");
        }
        return emsConnection;
    }

    private static synchronized EmsConnection loadConnection(Configuration pluginConfig, boolean copyConnectionLibraries, File tmpDir) throws Exception {
        if (connection == null) {
            try {
                ConnectionSettings connectionSettings = new ConnectionSettings();
                String connectionTypeDescriptorClass = pluginConfig.getSimple(CONNECTOR_DESCRIPTOR_TYPE).getStringValue();
                PropertySimple serverUrl = pluginConfig.getSimple(CONNECTOR_ADDRESS);
                connectionSettings.initializeConnectionType((ConnectionTypeDescriptor)Class.forName(connectionTypeDescriptorClass).newInstance());
                if (null != serverUrl) {
                    connectionSettings.setServerUrl(serverUrl.getStringValue());
                }
                connectionSettings.setPrincipal(pluginConfig.getSimpleValue(CONNECTOR_PRINCIPAL, null));
                connectionSettings.setCredentials(pluginConfig.getSimpleValue(CONNECTOR_CREDENTIALS, null));
                connectionSettings.setLibraryURI(pluginConfig.getSimpleValue(JBOSS_HOME_DIR, null));
                if (connectionSettings.getAdvancedProperties() == null) {
                    connectionSettings.setAdvancedProperties(new Properties());
                }
                connectionSettings.getAdvancedProperties().setProperty("mc4j.ems.UseContextClassLoader", "true");
                connectionSettings.getAdvancedProperties().setProperty(JNP_DISABLE_DISCOVERY_JNP_INIT_PROP, "true");
                connectionSettings.getAdvancedProperties().setProperty("jnp.timeout", String.valueOf(30000));
                connectionSettings.getAdvancedProperties().setProperty("jnp.sotimeout", String.valueOf(15000));
                connectionSettings.getAdvancedProperties().setProperty("mc4j.ems.UseContextClassLoader", Boolean.TRUE.toString());
                if (copyConnectionLibraries) {
                    connectionSettings.getControlProperties().setProperty("mc4j.ems.CopyJarsToTemp", String.valueOf(Boolean.TRUE));
                }
                connectionSettings.getControlProperties().setProperty("mc4j.ems.JarTempDir", tmpDir.getAbsolutePath());
                connectionSettings.getAdvancedProperties().setProperty("mc4j.ems.DefaultDomainSearch", "jboss");
                ConnectionFactory connectionFactory = new ConnectionFactory();
                connectionFactory.discoverServerClasses(connectionSettings);
                ConnectionProvider connectionProvider = connectionFactory.getConnectionProvider(connectionSettings);
                connection = connectionProvider.connect();
                connection.loadSynchronous(false);
                consecutiveConnectionErrors = 0;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Successfully made connection to the remote server instance");
                }
            }
            catch (Exception e) {
                if (connection != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Connection created but an exception was thrown. Closing the connection.", (Throwable)e);
                    }
                    connection.close();
                    connection = null;
                }
                if (consecutiveConnectionErrors % 10 == 0) {
                    log.warn((Object)("Could not establish connection to the instance [" + (consecutiveConnectionErrors + 1) + "] times."), (Throwable)e);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Could not connect to the instance for resource ", (Throwable)e);
                }
                ++consecutiveConnectionErrors;
                throw e;
            }
        }
        return connection;
    }

    public synchronized void closeConnection() {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                log.error((Object)("Error closing EMS connection: " + e));
            }
            connection = null;
        }
    }
}

