/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jbossas5.util.ConversionUtils;

public abstract class ManagedDeploymentDiscoveryComponent
implements ResourceDiscoveryComponent<ApplicationServerComponent<?>> {
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApplicationServerComponent<?>> discoveryContext) {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ResourceType resourceType = discoveryContext.getResourceType();
        this.log.trace((Object)("Discovering " + resourceType.getName() + " Resources..."));
        KnownDeploymentTypes deploymentType = ConversionUtils.getDeploymentType(resourceType);
        String deploymentTypeString = deploymentType.getType();
        ManagementView managementView = ((ApplicationServerComponent)discoveryContext.getParentResourceComponent()).getConnection().getManagementView();
        managementView.load();
        Set deploymentNames = null;
        try {
            deploymentNames = managementView.getDeploymentNamesForType(deploymentTypeString);
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to get deployment for type " + deploymentTypeString), (Throwable)e);
        }
        if (deploymentNames != null) {
            discoveredResources = new HashSet(deploymentNames.size());
            for (String deploymentName : deploymentNames) {
                try {
                    ManagedDeployment managedDeployment = managementView.getDeployment(deploymentName);
                    if (!this.accept(managedDeployment)) continue;
                    String resourceName = managedDeployment.getSimpleName();
                    if (resourceName.equals("%Generated%")) {
                        resourceName = ManagedDeploymentDiscoveryComponent.getResourceName(deploymentName);
                    }
                    String version = null;
                    DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, deploymentName, resourceName, version, resourceType.getDescription(), discoveryContext.getDefaultPluginConfiguration(), null);
                    resource.getPluginConfiguration().put((Property)new PropertySimple("deploymentName", (Object)deploymentName));
                    discoveredResources.add(resource);
                }
                catch (NoSuchDeploymentException e) {
                    this.log.error((Object)("ManagementView.getDeploymentNamesForType() returned [" + deploymentName + "] as a deployment name, but calling getDeployment() with that name failed."));
                }
                catch (Exception e) {
                    this.log.error((Object)("An error occurred while discovering " + resourceType + " Resources."), (Throwable)e);
                }
            }
        }
        this.log.trace((Object)("Discovered " + discoveredResources.size() + " " + resourceType.getName() + " Resources."));
        return discoveredResources;
    }

    protected abstract boolean accept(ManagedDeployment var1);

    private static String getResourceName(String fullPath) {
        int lastSlashIndex = fullPath.lastIndexOf("/");
        return fullPath.substring(lastSlashIndex + 1);
    }
}

