/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.adapter.impl.measurement;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.plugins.jbossas5.adapter.api.MeasurementAdapter;

public class SimpleMetaValueMeasurementAdapter
implements MeasurementAdapter {
    private final Log LOG = LogFactory.getLog(SimpleMetaValueMeasurementAdapter.class);

    @Override
    public void setMeasurementData(MeasurementReport report, MetaValue metaValue, MeasurementScheduleRequest request, MeasurementDefinition measurementDefinition) {
        SimpleValueSupport simpleValue = (SimpleValueSupport)metaValue;
        DataType dataType = measurementDefinition.getDataType();
        switch (dataType) {
            case MEASUREMENT: {
                try {
                    MeasurementDataNumeric dataNumeric = new MeasurementDataNumeric(request, new Double(simpleValue.getValue().toString()));
                    report.addData(dataNumeric);
                }
                catch (NumberFormatException e) {
                    this.LOG.warn((Object)("Measurement request: " + request.getName() + " did not return a numeric value from the Profile Service"), (Throwable)e);
                }
                break;
            }
            case TRAIT: {
                MeasurementDataTrait dataTrait = new MeasurementDataTrait(request, String.valueOf(simpleValue.getValue()));
                report.addData(dataTrait);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported measurement data type: " + dataType);
            }
        }
    }
}

