/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.connection;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnectionProvider;

public abstract class AbstractProfileServiceConnectionProvider
implements ProfileServiceConnectionProvider {
    private final Log log = LogFactory.getLog(this.getClass());
    private ProfileServiceConnection existingConnection;

    @Override
    public final ProfileServiceConnection connect() {
        this.existingConnection = this.doConnect();
        this.existingConnection.init();
        return this.existingConnection;
    }

    protected abstract ProfileServiceConnection doConnect();

    @Override
    public boolean isConnected() {
        return this.existingConnection != null;
    }

    @Override
    public final void disconnect() {
        if (this.isConnected()) {
            this.existingConnection = null;
            this.doDisconnect();
        }
    }

    protected abstract void doDisconnect();

    @Override
    public ProfileServiceConnection getExistingConnection() {
        return this.existingConnection;
    }

    protected InitialContext createInitialContext(Properties env) {
        InitialContext initialContext;
        this.log.debug((Object)("Creating JNDI InitialContext with env [" + env + "]..."));
        try {
            initialContext = new InitialContext(env);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to create JNDI InitialContext.", e);
        }
        this.log.debug((Object)("Created JNDI InitialContext [" + initialContext + "]."));
        return initialContext;
    }

    protected Object lookup(InitialContext initialContext, String name) {
        try {
            Object found = initialContext.lookup(name);
            return found;
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to lookup JNDI name '" + name + "' from InitialContext.", e);
        }
    }
}

