/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.util.ConversionUtils;

public abstract class AbstractManagedDeploymentDiscoveryComponent
implements ResourceDiscoveryComponent<ProfileServiceComponent<?>>,
ResourceUpgradeFacet<ProfileServiceComponent<?>> {
    private static final Log LOG = LogFactory.getLog(AbstractManagedDeploymentDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ProfileServiceComponent<?>> discoveryContext) {
        ProfileServiceComponent parentResourceComponent;
        ManagementView managementView;
        ResourceType resourceType = discoveryContext.getResourceType();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Discovering " + resourceType.getName() + " Resources..."));
        }
        if ((managementView = AbstractManagedDeploymentDiscoveryComponent.getManagementView((parentResourceComponent = (ProfileServiceComponent)discoveryContext.getParentResourceComponent()).getConnection())) == null) {
            return Collections.emptySet();
        }
        Set<String> deploymentNames = AbstractManagedDeploymentDiscoveryComponent.getDeploymentNamesForType(managementView, resourceType);
        if (deploymentNames.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>(deploymentNames.size());
        for (String deploymentName : deploymentNames) {
            try {
                ManagedDeployment managedDeployment = managementView.getDeployment(deploymentName);
                if (!this.accept(managedDeployment)) continue;
                String resourceName = managedDeployment.getSimpleName();
                if (resourceName.equals("%Generated%")) {
                    resourceName = deploymentName.substring(deploymentName.lastIndexOf("/") + 1);
                }
                String resourceKey = AbstractManagedDeploymentDiscoveryComponent.buildResourceKey(managedDeployment);
                DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, null, resourceType.getDescription(), discoveryContext.getDefaultPluginConfiguration(), null);
                String deploymentKey = URI.create(deploymentName).getPath();
                resource.getPluginConfiguration().put((Property)new PropertySimple("deploymentKey", (Object)deploymentKey));
                discoveredResources.add(resource);
            }
            catch (NoSuchDeploymentException e) {
                LOG.error((Object)("ManagementView.getDeploymentNamesForType() returned [" + deploymentName + "] as a deployment name, but calling getDeployment() with that name failed."));
            }
            catch (Exception e) {
                LOG.error((Object)("An error occurred while discovering " + resourceType + " resources."), (Throwable)e);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Discovered " + discoveredResources.size() + " " + resourceType.getName() + " resource(s)."));
        }
        return discoveredResources;
    }

    protected abstract boolean accept(ManagedDeployment var1);

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<ProfileServiceComponent<?>> upgradeContext) {
        String newResourceKey = null;
        String existingResourceKey = upgradeContext.getResourceKey();
        if (!existingResourceKey.startsWith("{")) {
            newResourceKey = this.getNewResourceKey(upgradeContext, existingResourceKey);
        }
        Configuration newPluginConfiguration = null;
        Configuration existingPluginConfig = upgradeContext.getPluginConfiguration();
        if (existingPluginConfig.getSimpleValue("deploymentName") != null) {
            newPluginConfiguration = this.getNewPluginConfig(upgradeContext);
        }
        if (newResourceKey != null || newPluginConfiguration != null) {
            ResourceUpgradeReport upgradeReport = new ResourceUpgradeReport();
            upgradeReport.setNewResourceKey(newResourceKey);
            upgradeReport.setNewPluginConfiguration(newPluginConfiguration);
            return upgradeReport;
        }
        return null;
    }

    private String getNewResourceKey(ResourceUpgradeContext<ProfileServiceComponent<?>> upgradeContext, String existingResourceKey) {
        ManagedDeployment deployment;
        ProfileServiceConnection connection = ((ProfileServiceComponent)upgradeContext.getParentResourceComponent()).getConnection();
        if (connection == null) {
            LOG.warn((Object)(this.getClass().getName() + ": could not upgrade resource, no profile service connection available"));
            return null;
        }
        ManagementView managementView = connection.getManagementView();
        try {
            deployment = managementView.getDeployment(existingResourceKey);
        }
        catch (NoSuchDeploymentException e) {
            throw new IllegalStateException(e);
        }
        String newResourceKey = AbstractManagedDeploymentDiscoveryComponent.buildResourceKey(deployment);
        return newResourceKey;
    }

    private Configuration getNewPluginConfig(ResourceUpgradeContext<ProfileServiceComponent<?>> upgradeContext) {
        Configuration newPluginConfiguration = upgradeContext.getPluginConfiguration().deepCopy(false);
        String deploymentName = newPluginConfiguration.getSimpleValue("deploymentName");
        newPluginConfiguration.remove("deploymentName");
        String deploymentKey = URI.create(deploymentName).getPath();
        newPluginConfiguration.put((Property)new PropertySimple("deploymentKey", (Object)deploymentKey));
        return newPluginConfiguration;
    }

    private static String buildResourceKey(ManagedDeployment deployment) {
        StringBuilder resourceKey = new StringBuilder();
        resourceKey.append('{').append("default").append("}");
        ArrayList<String> ancestryNames = new ArrayList<String>();
        ManagedDeployment parentDeployment = deployment;
        do {
            ancestryNames.add(0, parentDeployment.getSimpleName());
        } while ((parentDeployment = parentDeployment.getParent()) != null);
        int ancestryNamesSize = ancestryNames.size();
        for (int i = 0; i < ancestryNamesSize; ++i) {
            String deploymentSimpleName = (String)ancestryNames.get(i);
            resourceKey.append(deploymentSimpleName);
            if (i == ancestryNamesSize - 1) continue;
            resourceKey.append("/");
        }
        return resourceKey.toString();
    }

    static ManagementView getManagementView(ProfileServiceConnection connection) {
        if (connection == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No profile service connection available");
            }
            return null;
        }
        ManagementView managementView = connection.getManagementView();
        managementView.load();
        return managementView;
    }

    static Set<String> getDeploymentNamesForType(ManagementView managementView, ResourceType resourceType) {
        Set deploymentNames;
        KnownDeploymentTypes deploymentType = ConversionUtils.getDeploymentType(resourceType);
        String deploymentTypeString = deploymentType.getType();
        try {
            deploymentNames = managementView.getDeploymentNamesForType(deploymentTypeString);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to get deployment names for type " + deploymentTypeString), (Throwable)e);
            deploymentNames = Collections.emptySet();
        }
        return deploymentNames;
    }
}

