/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.plugins.jbossas5.ManagedComponentComponent;
import org.rhq.plugins.jbossas5.helper.MoreKnownComponentTypes;

public class ConnectorComponent
extends ManagedComponentComponent {
    private static final Log LOG = LogFactory.getLog(ConnectorComponent.class);
    private static final String THREAD_POOL_METRIC_PREFIX = "ThreadPool|";
    static final String PROTOCOL_PROPERTY = "protocol";
    static final String HOST_PROPERTY = "host";
    static final String ADDRESS_PROPERTY = "address";
    static final String PORT_PROPERTY = "port";

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        LinkedHashSet<MeasurementScheduleRequest> remainingRequests = new LinkedHashSet<MeasurementScheduleRequest>();
        String webThreadPoolComponentName = this.getWebThreadPoolComponentName(this.getResourceContext().getPluginConfiguration());
        ComponentType webThreadPoolComponentType = MoreKnownComponentTypes.MBean.WebThreadPool.getType();
        ManagementView managementView = this.getConnection().getManagementView();
        ManagedComponent webThreadPoolComponent = managementView.getComponent(webThreadPoolComponentName, webThreadPoolComponentType);
        for (MeasurementScheduleRequest request : requests) {
            String metricName = request.getName();
            try {
                if (metricName.startsWith(THREAD_POOL_METRIC_PREFIX)) {
                    Object value = this.getSimpleValue(webThreadPoolComponent, request);
                    this.addValueToMeasurementReport(report, request, value);
                    continue;
                }
                remainingRequests.add(request);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to collect metric '" + metricName + "' for " + this.getResourceContext().getResourceType() + " Resource with key " + this.getResourceContext().getResourceKey() + "."), (Throwable)e);
            }
        }
        super.getValues(report, remainingRequests);
    }

    private String getWebThreadPoolComponentName(Configuration pluginConfig) {
        StringBuilder webThreadPoolComponentNameBuilder = new StringBuilder("jboss.web:name=").append(pluginConfig.getSimpleValue(PROTOCOL_PROPERTY)).append("-");
        if (pluginConfig.getSimpleValue(HOST_PROPERTY) != null) {
            webThreadPoolComponentNameBuilder.append(pluginConfig.getSimpleValue(HOST_PROPERTY)).append("%2F");
        }
        webThreadPoolComponentNameBuilder.append(pluginConfig.getSimpleValue(ADDRESS_PROPERTY)).append("-").append(pluginConfig.getSimpleValue(PORT_PROPERTY)).append(",type=ThreadPool");
        return webThreadPoolComponentNameBuilder.toString();
    }
}

