/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.plugins.jbossas5.ManagedComponentComponent;

public class JmsDestinationComponent
extends ManagedComponentComponent {
    private static final String[] OBJECT_NAME_PROPERTY_NAMES = new String[]{"DLQ", "expiryQueue", "serverPeer"};

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        Configuration resourceConfig = configurationUpdateReport.getConfiguration();
        ArrayList<String> invalidObjectNamePropertyNames = new ArrayList<String>();
        for (String objectNamePropertyName : OBJECT_NAME_PROPERTY_NAMES) {
            PropertySimple propertySimple = resourceConfig.getSimple(objectNamePropertyName);
            try {
                JmsDestinationComponent.validateObjectNameProperty(propertySimple);
            }
            catch (MalformedObjectNameException e) {
                propertySimple.setErrorMessage("Invalid ObjectName: " + e.getLocalizedMessage());
                invalidObjectNamePropertyNames.add(propertySimple.getName());
            }
        }
        if (!invalidObjectNamePropertyNames.isEmpty()) {
            configurationUpdateReport.setErrorMessage("The following ObjectName properties have invalid values: " + invalidObjectNamePropertyNames);
        } else {
            super.updateResourceConfiguration(configurationUpdateReport);
        }
    }

    private static void validateObjectNameProperty(PropertySimple propertySimple) throws MalformedObjectNameException {
        ObjectName objectName;
        String value;
        if (propertySimple != null && (value = propertySimple.getStringValue()) != null && (objectName = new ObjectName(value)).isPattern()) {
            throw new MalformedObjectNameException("Patterns are not allowed.");
        }
    }
}

