/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.script;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jbossas5.script.ScriptFileFinder;

public class ScriptDiscoveryComponent
implements ResourceDiscoveryComponent<ApplicationServerComponent<?>>,
ManualAddFacet<ApplicationServerComponent<?>>,
ResourceUpgradeFacet<ApplicationServerComponent<?>> {
    private final Log log = LogFactory.getLog(this.getClass());
    static final String SERVER_HOME_DIR = "homeDir";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApplicationServerComponent<?>> discoveryContext) throws InvalidPluginConfigurationException {
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        ResourceContext parentResourceContext = discoveryContext.getParentResourceContext();
        File binDir = this.getServerBinDirectory(parentResourceContext);
        this.log.debug((Object)("Searching for scripts beneath JBossAS server bin directory (" + binDir + ")..."));
        ScriptFileFinder scriptFileFinder = new ScriptFileFinder(discoveryContext.getSystemInformation(), binDir);
        List<File> scriptFiles = scriptFileFinder.findScriptFiles();
        for (File scriptFile : scriptFiles) {
            Configuration pluginConfig = new Configuration();
            pluginConfig.put((Property)new PropertySimple("path", (Object)scriptFile.getPath()));
            Map<String, String> defaultScriptEnvironment = this.getDefaultScriptEnvironment();
            pluginConfig.put((Property)new PropertySimple("environmentVariables", (Object)this.toString(defaultScriptEnvironment)));
            DiscoveredResourceDetails resource = this.createResourceDetails(discoveryContext, pluginConfig, binDir);
            this.log.debug((Object)("Auto-discovered script service: " + resource));
            resources.add(resource);
        }
        return resources;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfig, ResourceDiscoveryContext<ApplicationServerComponent<?>> discoveryContext) throws InvalidPluginConfigurationException {
        File path = new File(pluginConfig.getSimple("path").getStringValue());
        this.validatePath(path);
        ResourceContext parentResourceContext = discoveryContext.getParentResourceContext();
        File binDir = this.getServerBinDirectory(parentResourceContext);
        DiscoveredResourceDetails resource = this.createResourceDetails(discoveryContext, pluginConfig, binDir);
        this.log.debug((Object)("Manually added script service: " + resource));
        return resource;
    }

    public ResourceUpgradeReport upgrade(ResourceUpgradeContext<ApplicationServerComponent<?>> upgradeContext) {
        ResourceContext parentResourceContext;
        File binDir;
        String inventoriedResourceKey = upgradeContext.getResourceKey();
        if (!inventoriedResourceKey.startsWith((binDir = this.getServerBinDirectory(parentResourceContext = upgradeContext.getParentResourceContext())).getPath())) {
            return null;
        }
        String resourceKey = ScriptDiscoveryComponent.buildResourceKey(inventoriedResourceKey, binDir);
        ResourceUpgradeReport upgradeReport = new ResourceUpgradeReport();
        upgradeReport.setNewResourceKey(resourceKey);
        return upgradeReport;
    }

    private File getServerBinDirectory(ResourceContext parentResourceContext) {
        Configuration parentPluginConfig = parentResourceContext.getPluginConfiguration();
        String homeDir = parentPluginConfig.getSimple(SERVER_HOME_DIR).getStringValue();
        return new File(homeDir, "bin");
    }

    private static String buildResourceKey(String scriptPath, File binDir) {
        return scriptPath.startsWith(binDir.getPath()) ? scriptPath.substring(binDir.getPath().length() + 1) : scriptPath;
    }

    private void validatePath(File path) {
        if (!path.isAbsolute()) {
            throw new InvalidPluginConfigurationException("Path '" + path + "' is not absolute.");
        }
        if (!path.exists()) {
            throw new InvalidPluginConfigurationException("Path '" + path + "' does not exist.");
        }
        if (path.isDirectory()) {
            throw new InvalidPluginConfigurationException("Path '" + path + "' is a directory, not a file.");
        }
    }

    private Map<String, String> getDefaultScriptEnvironment() {
        HashMap<String, String> defaultScriptEnvironment = new HashMap<String, String>();
        defaultScriptEnvironment.put("JBOSS_SERVER_NAME", "%serverName%");
        defaultScriptEnvironment.put("JBOSS_SERVER_HOME_DIR", "%serverHomeDir%");
        return defaultScriptEnvironment;
    }

    private String toString(Map<String, String> defaultScriptEnvironment) {
        StringBuilder environmentVariables = new StringBuilder();
        if (defaultScriptEnvironment != null) {
            for (String varName : defaultScriptEnvironment.keySet()) {
                String varValue = defaultScriptEnvironment.get(varName);
                environmentVariables.append(varName).append("=").append(varValue).append("\n");
            }
        }
        return environmentVariables.toString();
    }

    private DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext<ApplicationServerComponent<?>> discoveryContext, Configuration pluginConfig, File binDir) {
        String path = pluginConfig.getSimple("path").getStringValue();
        String key = ScriptDiscoveryComponent.buildResourceKey(path, binDir);
        String name = new File(path).getName();
        String version = null;
        String description = null;
        ProcessInfo processInfo = null;
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, version, description, pluginConfig, processInfo);
    }
}

