/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.File;
import java.util.Set;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.util.ConnectionFactoryConfigurationEditor;
import org.rhq.plugins.jbossas.util.JBossMBeanUtility;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactoryComponent
extends MBeanResourceComponent<JBossASServerComponent>
implements ConfigurationFacet,
DeleteResourceFacet {
    private static final String CONNECTION_POOL_OBJECT_NAME = "jboss.jca:name=%NAME%,service=ManagedConnectionPool";
    private EmsBean connectionPoolBean;
    private String name;

    public AvailabilityType getAvailability() {
        return JBossMBeanUtility.isStarted(this.getEmsBean(), this.getResourceContext()) ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void start(ResourceContext<JBossASServerComponent> resourceContext) {
        super.start(resourceContext);
        this.name = this.getResourceContext().getPluginConfiguration().getSimpleValue("name", null);
        String connectionPoolBeanName = CONNECTION_POOL_OBJECT_NAME.replace("%NAME%", this.name);
        this.connectionPoolBean = this.getEmsConnection().getBean(connectionPoolBeanName);
    }

    public Configuration loadResourceConfiguration() {
        File deploymentFile = ((JBossASServerComponent)this.getResourceContext().getParentResourceComponent()).getDeploymentFilePath(this.getResourceContext().getResourceKey());
        assert (deploymentFile.exists()) : "Deployment file " + deploymentFile + " doesn't exist for resource " + this.getResourceContext().getResourceKey();
        return ConnectionFactoryConfigurationEditor.loadConnectionFactory(deploymentFile, this.name);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        JBossASServerComponent parentComponent = (JBossASServerComponent)this.getResourceContext().getParentResourceComponent();
        File deploymentFile = parentComponent.getDeploymentFilePath(this.getResourceContext().getResourceKey());
        if (deploymentFile == null) {
            report.setErrorMessage("Parent resource is currently down. Unable to complete update of connection factory " + this.name);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        } else {
            if (!deploymentFile.exists()) {
                deploymentFile = new File(parentComponent.getConfigurationPath(), this.name + "-ds.xml");
            }
            ConnectionFactoryConfigurationEditor.updateConnectionFactory(deploymentFile, this.name, report);
        }
    }

    public void deleteResource() throws Exception {
        JBossASServerComponent jbossASComponent = (JBossASServerComponent)this.getResourceContext().getParentResourceComponent();
        File deploymentFile = jbossASComponent.getDeploymentFilePath(this.getResourceContext().getResourceKey());
        assert (deploymentFile.exists()) : "Deployment file " + deploymentFile + " doesn't exist for resource " + this.getResourceContext().getResourceKey();
        ConnectionFactoryConfigurationEditor.deleteConnectionFactory(deploymentFile, this.name);
        jbossASComponent.redeployFile(deploymentFile);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        super.getValues(report, requests, this.connectionPoolBean);
    }
}

