/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.measurement.calltime.CallTimeDataValue;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.util.JBossMBeanUtility;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3BeanComponent
extends MBeanResourceComponent<JBossASServerComponent> {
    private final Log log = LogFactory.getLog(EJB3BeanComponent.class);
    private Map<Integer, CallTimeData> previousRawCallTimeDatas = new HashMap<Integer, CallTimeData>();

    public AvailabilityType getAvailability() {
        return JBossMBeanUtility.isStarted(this.getEmsBean(), this.getResourceContext()) ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if ("viewMethodStats".equals(name)) {
            Object invocationStatistics = this.getInvocationStatistics();
            OperationResult result = new OperationResult();
            PropertyList methodList = new PropertyList("methods");
            result.getComplexResults().put((Property)methodList);
            Map<String, Object> stats = this.getStats(invocationStatistics);
            for (String methodName : stats.keySet()) {
                Object timeStatistic = stats.get(methodName);
                Long count = (Long)timeStatistic.getClass().getField("count").get(timeStatistic);
                Long minTime = (Long)timeStatistic.getClass().getField("minTime").get(timeStatistic);
                Long maxTime = (Long)timeStatistic.getClass().getField("maxTime").get(timeStatistic);
                Long totalTime = (Long)timeStatistic.getClass().getField("totalTime").get(timeStatistic);
                PropertyMap method = new PropertyMap("method", new Property[]{new PropertySimple("methodName", (Object)methodName), new PropertySimple("count", (Object)count), new PropertySimple("minTime", (Object)minTime), new PropertySimple("maxTime", (Object)maxTime), new PropertySimple("totalTime", (Object)totalTime)});
                methodList.add((Property)method);
            }
            return result;
        }
        return super.invokeOperation(name, parameters);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> schedules) {
        LinkedHashSet<MeasurementScheduleRequest> numericMetricSchedules = new LinkedHashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest schedule : schedules) {
            Object invocationStatistics;
            if (schedule.getDataType() == DataType.MEASUREMENT) {
                numericMetricSchedules.add(schedule);
                continue;
            }
            if (!schedule.getName().equals("MethodInvocationTime")) continue;
            try {
                invocationStatistics = this.getInvocationStatistics();
            }
            catch (Exception e) {
                continue;
            }
            try {
                long lastResetTime = this.getLastResetTime(invocationStatistics);
                Map<String, Object> stats = this.getStats(invocationStatistics);
                long collectionTime = System.currentTimeMillis();
                if (stats.isEmpty()) continue;
                CallTimeData callTimeData = this.createCallTimeData(schedule, stats, new Date(lastResetTime), new Date(collectionTime));
                report.addData(callTimeData);
            }
            catch (Exception e) {
                this.log.error((Object)"Failed to retrieve EJB3 call-time data.", (Throwable)e);
            }
        }
        super.getValues(report, numericMetricSchedules);
    }

    private CallTimeData createCallTimeData(MeasurementScheduleRequest schedule, Map<String, Object> stats, Date lastResetTime, Date collectionTime) throws Exception {
        CallTimeData previousRawCallTimeData = this.previousRawCallTimeDatas.get(schedule.getScheduleId());
        CallTimeData rawCallTimeData = new CallTimeData(schedule);
        this.previousRawCallTimeDatas.put(schedule.getScheduleId(), rawCallTimeData);
        CallTimeData callTimeData = new CallTimeData(schedule);
        for (String methodName : stats.keySet()) {
            long countSincePrevious;
            Object timeStatistic = stats.get(methodName);
            long minTime = (Long)timeStatistic.getClass().getField("minTime").get(timeStatistic);
            long maxTime = (Long)timeStatistic.getClass().getField("maxTime").get(timeStatistic);
            long totalTime = (Long)timeStatistic.getClass().getField("totalTime").get(timeStatistic);
            long count = (Long)timeStatistic.getClass().getField("count").get(timeStatistic);
            if (count == 0L) continue;
            rawCallTimeData.addAggregatedCallData(methodName, lastResetTime, collectionTime, (double)minTime, (double)maxTime, (double)totalTime, count);
            CallTimeDataValue previousValue = previousRawCallTimeData != null ? (CallTimeDataValue)previousRawCallTimeData.getValues().get(methodName) : null;
            boolean supercedesPrevious = previousValue != null && previousValue.getBeginTime() == lastResetTime.getTime();
            Date beginTime = lastResetTime;
            if (supercedesPrevious && (countSincePrevious = count - previousValue.getCount()) > 0L) {
                beginTime = new Date(previousValue.getEndTime());
                count = countSincePrevious;
                totalTime -= (long)previousValue.getTotal();
            }
            callTimeData.addAggregatedCallData(methodName, beginTime, collectionTime, (double)minTime, (double)maxTime, (double)totalTime, count);
        }
        return callTimeData;
    }

    private Object getInvocationStatistics() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getEmsBean().getClass().getClassLoader());
        Object invocationStatistics = null;
        try {
            invocationStatistics = this.getEmsBean().getAttribute("InvokeStats").refresh();
        }
        catch (RuntimeException e) {
            String msg = "Failed to retrieve EJB3 invocation stats - perhaps JBoss EJB3 impl version is less than RC9 Patch 1.";
            this.log.info((Object)(msg + " Enable DEBUG logging to see cause."));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)msg, (Throwable)e);
            }
            throw new Exception(msg, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return invocationStatistics;
    }

    private long getLastResetTime(Object invocationStatistics) throws Exception {
        Field field = invocationStatistics.getClass().getField("lastResetTime");
        return (Long)field.get(invocationStatistics);
    }

    private Map<String, Object> getStats(Object invocationStatistics) throws Exception {
        Method method = invocationStatistics.getClass().getMethod("getStats", new Class[0]);
        return (Map)method.invoke(invocationStatistics, new Object[0]);
    }
}

