/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.EmsBeanName;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASTomcatConnectorDiscoveryComponent
extends MBeanResourceDiscoveryComponent<JMXComponent> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> context) {
        ObjectNameQueryUtility queryUtility;
        Set resourceDetails = super.discoverResources(context);
        EmsConnection connection = ((JMXComponent)context.getParentResourceComponent()).getEmsConnection();
        List beans = connection.queryBeans((queryUtility = new ObjectNameQueryUtility("jboss.web:type=GlobalRequestProcessor,name=%name%")).getTranslatedQuery());
        if (beans.size() != resourceDetails.size()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"jboss.web:type=GlobalRequestProcessor,name=* MBeans are not fully deployed yet - aborting...");
            }
            return Collections.emptySet();
        }
        HashMap<String, String> schemeMap = new HashMap<String, String>(beans.size());
        HashMap<String, Boolean> addressPresentMap = new HashMap<String, Boolean>(beans.size());
        for (EmsBean bean : beans) {
            EmsBeanName eName = bean.getBeanName();
            String oName = eName.getKeyProperty("name");
            int firstDashIndex = oName.indexOf(45);
            String scheme = oName.substring(0, firstDashIndex);
            String remainder = oName.substring(firstDashIndex + 1);
            int lastDashIndex = remainder.lastIndexOf(45);
            String port = remainder.substring(lastDashIndex + 1);
            schemeMap.put(port, scheme);
            boolean addressPresent = lastDashIndex != -1;
            addressPresentMap.put(port, addressPresent);
        }
        for (DiscoveredResourceDetails resource : resourceDetails) {
            String cleanAddress;
            Configuration pluginConfiguration = resource.getPluginConfiguration();
            String dirtyAddress = pluginConfiguration.getSimple("address").getStringValue();
            if (dirtyAddress.startsWith("%2F")) {
                cleanAddress = dirtyAddress.substring(3);
                String dirtyResourceKey = resource.getResourceKey();
                String cleanResourceKey = dirtyResourceKey.replace(dirtyAddress, cleanAddress);
                resource.setResourceKey(cleanResourceKey);
            } else {
                cleanAddress = dirtyAddress;
            }
            String port = pluginConfiguration.getSimple("port").getStringValue();
            String resourceName = resource.getResourceName();
            resource.setResourceName(resourceName);
            String scheme = (String)schemeMap.get(port);
            pluginConfiguration.put((Property)new PropertySimple("schema", (Object)scheme));
            if (addressPresentMap.containsKey(port)) {
                pluginConfiguration.put((Property)new PropertySimple("address", (Object)cleanAddress));
                pluginConfiguration.put((Property)new PropertySimple("-", (Object)"-"));
            } else {
                pluginConfiguration.put((Property)new PropertySimple("address", (Object)""));
                pluginConfiguration.put((Property)new PropertySimple("-", (Object)""));
            }
            this.log.debug((Object)("Found a JBoss Web connector: " + scheme + "-" + cleanAddress + ":" + port));
        }
        return resourceDetails;
    }
}

