/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jbossas.JBossASServerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASTomcatDiscoveryComponent
implements ResourceDiscoveryComponent<JBossASServerComponent> {
    private final Log log = LogFactory.getLog(JBossASTomcatDiscoveryComponent.class);
    public static final String EMBEDDED_TOMCAT_PRE42_DIR = "jbossweb-tomcat";
    public static final String EMBEDDED_TOMCAT_42_DIR = "jboss-web.";
    private static final String SERVER_INFO_PROPERTIES_RESOURCE = "org/apache/catalina/util/ServerInfo.properties";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JBossASServerComponent> context) throws InvalidPluginConfigurationException, Exception {
        this.log.debug((Object)"Discovering Tomcat servers embedded in JBossAS server...");
        File configDir = ((JBossASServerComponent)context.getParentResourceComponent()).getConfigurationPath();
        File deployDir = new File(configDir, "deploy");
        File[] jbossWebDirs = deployDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                boolean pre42 = file.getName().startsWith(JBossASTomcatDiscoveryComponent.EMBEDDED_TOMCAT_PRE42_DIR);
                boolean is42 = file.getName().startsWith(JBossASTomcatDiscoveryComponent.EMBEDDED_TOMCAT_42_DIR);
                return file.isDirectory() && (pre42 || is42);
            }
        });
        if (!deployDir.isDirectory() || null == jbossWebDirs) {
            throw new InvalidPluginConfigurationException("Invalid deploy directory: " + deployDir.getAbsolutePath());
        }
        HashSet<DiscoveredResourceDetails> set = new HashSet<DiscoveredResourceDetails>();
        for (File jbossWebDir : jbossWebDirs) {
            String key = jbossWebDir.getName();
            boolean pre42 = jbossWebDir.getName().startsWith(EMBEDDED_TOMCAT_PRE42_DIR);
            String serverName = pre42 ? "Tomcat" : "JBossWeb";
            String version = this.getVersion(jbossWebDir);
            String description = "JBossAS-Embedded " + serverName + " Web Server (" + jbossWebDir.getName() + File.separator + ")";
            Configuration pluginConfig = null;
            ProcessInfo processInfo = null;
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), key, this.getResourceName(pre42), version, description, pluginConfig, processInfo);
            set.add(resource);
        }
        return set;
    }

    private String getResourceName(boolean pre42) {
        return pre42 ? "Embedded Tomcat Server" : "Embedded JBossWeb Server";
    }

    private String getVersion(File jbossWebDir) throws IOException {
        boolean pre42 = jbossWebDir.getName().startsWith(EMBEDDED_TOMCAT_PRE42_DIR);
        String jarFileName = pre42 ? "catalina.jar" : "jbossweb.jar";
        File jarFile = new File(jbossWebDir, jarFileName);
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURL()});
        InputStream stream = ((ClassLoader)classLoader).getResourceAsStream(SERVER_INFO_PROPERTIES_RESOURCE);
        String version = null;
        if (stream != null) {
            String info;
            Properties serverInfo = new Properties();
            serverInfo.load(stream);
            stream.close();
            version = serverInfo.getProperty("server.number");
            if (version == null && (info = serverInfo.getProperty("server.info")) != null) {
                version = info.substring(info.indexOf(47) + 1);
            }
        }
        if (version == null) {
            version = "?";
            this.log.error((Object)("Failed to determine version of Embedded Tomcat server located at '" + jbossWebDir + "'"));
        }
        return version;
    }
}

