/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactoryConfigurationEditor {
    private static final String XA_TX_TYPE = "tx-connection-factory";
    private static final String[] COMMON_PROPS = new String[]{"jndi-name", "user-name", "password", "min-pool-size", "max-pool-size", "adapter-display-name", "rar-name", "connection-definition", "track-connection-by-tx", "use-java-context", "no-tx-separate-pools", "isSameRM-override-value", "use-strict-min", "depends", "prefill", "blocking-timeout-millis", "type-mapping", "new-connection-sql", "check-valid-connection-sql", "idle-timeout-minutes"};
    private static final List<String> blankProps = new ArrayList<String>();
    private static final String[] XA_PROPS;
    private static final String APPLICATION_MANAGED_SECURITY = "application-managed-security";
    private static final String SECURITY_AND_APPLICATION = "security-domain-and-application";
    private static final String SECURITY_APP_MANAGED = "security-domain";
    private static final String SECURITY_DOMAIN = "security-domain";
    private static final String TRANSACTION_TYPE_PROPERTY = "transaction-type";
    private static final String LOCAL_TX_TYPE_PROPERTY_VALUE = "Local Transaction";
    private static final String XA_TX_TYPE_PROPERTY_VALUE = "XA Transaction";
    private static final String CONFIG_PROPERTY = "config-property";
    private static final String CONFIG_PROPERTY_NAME = "config-property-name";
    private static final String CONFIG_PROPERTY_TYPE = "config-property-type";
    private static final String CONFIG_PROPERTY_VALUE = "config-property-value";
    private static Log log;

    public static Configuration loadConnectionFactory(File file, String name) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            if (!root.getName().equals("connection-factories")) {
                return null;
            }
            Element connectionFactoryElement = ConnectionFactoryConfigurationEditor.findConnectionFactoryElement(root, name);
            if (connectionFactoryElement == null) {
                return null;
            }
            Configuration config = new Configuration();
            String type = connectionFactoryElement.getName();
            config.put((Property)new PropertySimple("type", (Object)type));
            ConnectionFactoryConfigurationEditor.bindElements(connectionFactoryElement, config, COMMON_PROPS);
            ConnectionFactoryConfigurationEditor.bindSecurityInfo(connectionFactoryElement, config);
            ConnectionFactoryConfigurationEditor.bindTransactionType(connectionFactoryElement, config);
            if (type.equals(XA_TX_TYPE)) {
                ConnectionFactoryConfigurationEditor.bindElements(connectionFactoryElement, config, XA_PROPS);
            }
            ConnectionFactoryConfigurationEditor.bindList(connectionFactoryElement, config, CONFIG_PROPERTY);
            return config;
        }
        catch (IOException e) {
            log.error((Object)("IO error occurred while reading file: " + file), (Throwable)e);
        }
        catch (JDOMException e) {
            log.error((Object)("Parsing error occurred while reading file: " + file), (Throwable)e);
        }
        return null;
    }

    public static void updateConnectionFactory(File deploymentFile, String name, ConfigurationUpdateReport report) {
        try {
            ConnectionFactoryConfigurationEditor.updateConnectionFactory(deploymentFile, name, report.getConfiguration());
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (IOException e) {
            report.setErrorMessageFromThrowable((Throwable)e);
            log.error((Object)("IO error occurred while updating connection factory at file: " + deploymentFile), (Throwable)e);
        }
        catch (JDOMException e) {
            report.setErrorMessageFromThrowable((Throwable)e);
            log.error((Object)("Parsing error occurred while updating connection factory at file: " + deploymentFile), (Throwable)e);
        }
        catch (Exception e) {
            report.setErrorMessageFromThrowable((Throwable)e);
            log.error((Object)("Unable to update connection factory at file" + deploymentFile), (Throwable)e);
        }
    }

    public static void updateConnectionFactory(File deploymentFile, String name, CreateResourceReport report) {
        try {
            ConnectionFactoryConfigurationEditor.updateConnectionFactory(deploymentFile, name, report.getResourceConfiguration());
            report.setStatus(CreateResourceStatus.SUCCESS);
        }
        catch (IOException e) {
            report.setException((Throwable)e);
            log.error((Object)("IO error occurred while creating connection factory at file: " + deploymentFile), (Throwable)e);
        }
        catch (JDOMException e) {
            report.setException((Throwable)e);
            log.error((Object)("Parsing error occurred while creating connection factory at file: " + deploymentFile), (Throwable)e);
        }
        catch (Exception e) {
            report.setException((Throwable)e);
            log.error((Object)("Unable to create connection factory at file" + deploymentFile), (Throwable)e);
        }
    }

    private static void updateConnectionFactory(File deploymentFile, String name, Configuration config) throws JDOMException, IOException {
        Element root;
        Document doc;
        if (deploymentFile.exists()) {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(deploymentFile);
            root = doc.getRootElement();
        } else {
            doc = new Document();
            root = new Element("connection-factories");
            doc.setRootElement(root);
        }
        if (!root.getName().equals("connection-factories")) {
            throw new RuntimeException("Connection Factory file format exception on [" + deploymentFile + "], expected [connection-factories] element but found [" + root.getName() + "]");
        }
        Element connectionFactoryElement = ConnectionFactoryConfigurationEditor.findConnectionFactoryElement(root, name);
        String type = config.getSimpleValue("type", null);
        boolean isNewConnectionFactory = false;
        if (connectionFactoryElement == null) {
            connectionFactoryElement = new Element(type);
            isNewConnectionFactory = true;
        } else if (!type.equals(connectionFactoryElement.getName())) {
            connectionFactoryElement.setName(type);
        }
        ConnectionFactoryConfigurationEditor.updateElements(connectionFactoryElement, config, COMMON_PROPS);
        ConnectionFactoryConfigurationEditor.updateSecurityInfo(connectionFactoryElement, config);
        ConnectionFactoryConfigurationEditor.updateTransactionType(connectionFactoryElement, config);
        if (type.equals(XA_TX_TYPE)) {
            ConnectionFactoryConfigurationEditor.updateElements(connectionFactoryElement, config, XA_PROPS);
        }
        ConnectionFactoryConfigurationEditor.updateList(connectionFactoryElement, config, CONFIG_PROPERTY);
        if (isNewConnectionFactory) {
            root.addContent((Content)connectionFactoryElement);
        }
        ConnectionFactoryConfigurationEditor.updateFile(deploymentFile, doc);
    }

    public static void deleteConnectionFactory(File deploymentFile, String name) {
        if (deploymentFile != null && deploymentFile.exists()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(deploymentFile);
                Element root = doc.getRootElement();
                if (root != null) {
                    if (!root.getName().equals("connection-factories")) {
                        throw new RuntimeException("Connection Factory file format exception on [" + deploymentFile + "], expected [connection-factories] element but found [" + root.getName() + "]");
                    }
                    Element connectionFactoryElement = ConnectionFactoryConfigurationEditor.findConnectionFactoryElement(root, name);
                    root.removeContent((Content)connectionFactoryElement);
                }
                ConnectionFactoryConfigurationEditor.updateFile(deploymentFile, doc);
            }
            catch (JDOMException e) {
                log.error((Object)("Parsing error occurred while deleting connection factory at file: " + deploymentFile), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("IO error occurred while deleting connection factory at file: " + deploymentFile), (Throwable)e);
            }
        }
    }

    private static void updateList(Element parent, Configuration config, String propertyName) {
        PropertyList propertyList = config.getList(propertyName);
        List elementList = parent.getChildren(propertyName);
        if (!elementList.isEmpty()) {
            parent.removeChildren(propertyName);
        }
        for (Property property : propertyList.getList()) {
            Element element = new Element(propertyName);
            if (propertyName.equals(CONFIG_PROPERTY)) {
                ConnectionFactoryConfigurationEditor.setListElementValuesForConfigProperties(property, element);
            } else {
                ConnectionFactoryConfigurationEditor.setListElementValuesForDepends(property, element);
            }
            parent.addContent((Content)element);
        }
    }

    private static void setListElementValuesForConfigProperties(Property property, Element element) {
        PropertyMap propertyMap = (PropertyMap)property;
        PropertySimple configPropertyName = (PropertySimple)propertyMap.getMap().get(CONFIG_PROPERTY_NAME);
        PropertySimple configPropertyType = (PropertySimple)propertyMap.getMap().get(CONFIG_PROPERTY_TYPE);
        PropertySimple configPropertyValue = (PropertySimple)propertyMap.getMap().get(CONFIG_PROPERTY_VALUE);
        element.setAttribute("name", configPropertyName.getStringValue());
        element.setAttribute("type", configPropertyType.getStringValue());
        element.setText(configPropertyValue.getStringValue());
    }

    public static void setListElementValuesForDepends(Property property, Element element) {
        PropertySimple propertySimple = (PropertySimple)property;
        element.setText(propertySimple.getStringValue());
    }

    private static void updateElements(Element parent, Configuration config, String[] names) {
        for (String prop : names) {
            ConnectionFactoryConfigurationEditor.updateElement(parent, config, prop);
        }
    }

    private static void updateElement(Element parent, Configuration config, String name) {
        String value = config.getSimpleValue(name, null);
        Element child = parent.getChild(name);
        if (value == null || value.equals("")) {
            if (child != null) {
                parent.removeContent((Content)child);
            }
        } else {
            if (child == null) {
                child = new Element(name);
                parent.addContent((Content)child);
            }
            if (blankProps.contains(name)) {
                if (value.equals("false")) {
                    parent.removeContent((Content)child);
                }
            } else {
                child.setText(value);
            }
        }
    }

    private static void updateSecurityInfo(Element parent, Configuration config) {
        String appManagedValue = config.getSimpleValue(APPLICATION_MANAGED_SECURITY, null);
        String securityDomainValue = config.getSimpleValue("security-domain", null);
        Element useApplication = parent.getChild(APPLICATION_MANAGED_SECURITY);
        Element securityDomain = parent.getChild("security-domain");
        Element securityAndApp = parent.getChild(SECURITY_AND_APPLICATION);
        if (appManagedValue == null) {
            if (useApplication != null) {
                parent.removeContent((Content)useApplication);
            }
            if (securityDomain != null) {
                parent.removeContent((Content)securityDomain);
            }
            if (securityDomainValue != null && !securityDomainValue.equals("")) {
                if (securityAndApp == null) {
                    securityAndApp = new Element(SECURITY_AND_APPLICATION);
                    parent.addContent((Content)securityAndApp);
                }
                securityAndApp.setText(securityDomainValue);
            }
        } else {
            if (securityDomainValue == null || securityDomainValue.equals("")) {
                log.error((Object)"Security Domain property is required if selecting to use Application Managed Security");
                throw new RuntimeException("Security Domain property is required if selecting to use Application Managed Security");
            }
            if (useApplication == null) {
                useApplication = new Element(APPLICATION_MANAGED_SECURITY);
                parent.addContent((Content)useApplication);
            }
            if (securityAndApp != null) {
                parent.removeContent((Content)securityAndApp);
            }
            if (securityDomain == null) {
                securityDomain = new Element("security-domain");
            }
            securityDomain.setText(securityDomainValue);
        }
    }

    private static void updateTransactionType(Element parent, Configuration config) {
        String transactionType = config.getSimpleValue(TRANSACTION_TYPE_PROPERTY, null);
        Element useLocalTransactionType = parent.getChild("local-transaction");
        Element useXATransactionType = parent.getChild("xa-transaction");
        if (useLocalTransactionType != null) {
            parent.removeChild("local-transaction");
        }
        if (useXATransactionType != null) {
            parent.removeChild("xa-transaction");
        }
        if (transactionType != null) {
            if (transactionType.equals(LOCAL_TX_TYPE_PROPERTY_VALUE)) {
                Element child = new Element("local-transaction");
                parent.addContent((Content)child);
            } else {
                Element child = new Element("xa-transaction");
                parent.addContent((Content)child);
            }
        }
    }

    private static void bindList(Element parent, Configuration config, String listName) {
        PropertyList propertyList = new PropertyList(listName);
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Object child : parent.getChildren(listName)) {
            Element childElement = (Element)child;
            if (listName.equals(CONFIG_PROPERTY)) {
                ConnectionFactoryConfigurationEditor.setListOfConfigProperties(properties, childElement);
                continue;
            }
            ConnectionFactoryConfigurationEditor.setListOfDependencyProperties(properties, childElement);
        }
        propertyList.setList(properties);
        config.put((Property)propertyList);
    }

    private static void setListOfConfigProperties(List<Property> propertyList, Element element) {
        String name = element.getAttributeValue("name");
        String type = element.getAttributeValue("type");
        String value = element.getText();
        PropertyMap map = new PropertyMap("property-values");
        map.put((Property)new PropertySimple(CONFIG_PROPERTY_NAME, (Object)name));
        map.put((Property)new PropertySimple(CONFIG_PROPERTY_TYPE, (Object)type));
        map.put((Property)new PropertySimple(CONFIG_PROPERTY_VALUE, (Object)value));
        propertyList.add((Property)map);
    }

    private static void setListOfDependencyProperties(List<Property> propertyList, Element element) {
    }

    private static void bindElements(Element parent, Configuration config, String[] names) {
        for (String prop : names) {
            ConnectionFactoryConfigurationEditor.bindElement(parent, config, prop);
        }
    }

    private static void bindElement(Element parent, Configuration config, String name) {
        Element child = parent.getChild(name);
        if (child != null) {
            if (!blankProps.contains(name)) {
                config.put((Property)new PropertySimple(name, (Object)child.getText()));
            } else {
                config.put((Property)new PropertySimple(name, (Object)"true"));
            }
        }
    }

    private static void bindSecurityInfo(Element parent, Configuration config) {
        Element useApplication = parent.getChild(APPLICATION_MANAGED_SECURITY);
        if (useApplication != null) {
            config.put((Property)new PropertySimple(APPLICATION_MANAGED_SECURITY, (Object)"true"));
            Element securityDomain = parent.getChild("security-domain");
            if (securityDomain != null) {
                config.put((Property)new PropertySimple("security-domain", (Object)securityDomain.getValue()));
            } else {
                config.put((Property)new PropertySimple("security-domain", (Object)"Value required with App Managed Security"));
            }
        } else {
            Element domainAndApplication = parent.getChild(SECURITY_AND_APPLICATION);
            if (domainAndApplication != null) {
                config.put((Property)new PropertySimple("security-domain", (Object)domainAndApplication.getValue()));
            }
        }
    }

    private static void bindTransactionType(Element parent, Configuration config) {
        Element useLocalTransactionType = parent.getChild("local-transaction");
        Element useXATransactionType = parent.getChild("xa-transaction");
        if (useXATransactionType != null && useLocalTransactionType != null || useXATransactionType == null && useLocalTransactionType == null) {
            return;
        }
        if (useLocalTransactionType != null) {
            config.put((Property)new PropertySimple(TRANSACTION_TYPE_PROPERTY, (Object)LOCAL_TX_TYPE_PROPERTY_VALUE));
        }
        if (useXATransactionType != null) {
            config.put((Property)new PropertySimple(TRANSACTION_TYPE_PROPERTY, (Object)XA_TX_TYPE_PROPERTY_VALUE));
        }
    }

    private static Element findConnectionFactoryElement(Element root, String name) {
        for (Object child : root.getChildren()) {
            Element childElement = (Element)child;
            String jndiName = childElement.getChildText("jndi-name");
            if (!name.equals(jndiName)) continue;
            return childElement;
        }
        return null;
    }

    private static void updateFile(File deploymentFile, Document doc) throws JDOMException, IOException {
        FileOutputStream fos = new FileOutputStream(deploymentFile);
        XMLOutputter outp = new XMLOutputter(Format.getPrettyFormat());
        outp.output(doc, (OutputStream)fos);
        fos.flush();
        fos.close();
    }

    static {
        blankProps.add("track-connection-by-tx");
        XA_PROPS = new String[]{"xa-resource-timeout"};
        log = LogFactory.getLog(ConnectionFactoryConfigurationEditor.class);
    }
}

