/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.plugins.jbossas.util.AbstractMessagingConfigurationEditor;
import org.rhq.plugins.jbossas.util.XMLConfigurationEditor;

public class JMSConfigurationEditor
extends AbstractMessagingConfigurationEditor
implements XMLConfigurationEditor {
    private static final Log LOG = LogFactory.getLog(JMSConfigurationEditor.class);
    private static final String SECURITY_CONF = "SecurityConf";
    private static Map<String, String> types = new HashMap<String, String>();
    private static Map<String, String> codes = new HashMap<String, String>();
    private String[] dependsProperties;
    private String[] simpleAttributeProperties;

    public JMSConfigurationEditor(String type) {
        types.put("JMQ JMS Topic", "jboss.mq.destination:service=Topic");
        types.put("JMQ JMS Queue", "jboss.mq.destination:service=Queue");
        codes.put("JMQ JMS Topic", "org.jboss.mq.server.jmx.Topic");
        codes.put("JMQ JMS Queue", "org.jboss.mq.server.jmx.Queue");
        this.dependsProperties = new String[]{"DestinationManager", "SecurityManager", "ExpiryDestination"};
        this.simpleAttributeProperties = new String[]{"JNDIName", "InMemory", "RedeliveryLimit", "RedeliveryDelay", "MessageCounterHistoryDayLimit", "MaxDepth", "RecoveryRetries"};
        this.type = types.get(type);
        this.code = codes.get(type);
        this.securityConfig = SECURITY_CONF;
    }

    @Override
    public void updateConfiguration(File deploymentFile, String name, ConfigurationUpdateReport report) {
        report.setStatus(ConfigurationUpdateStatus.INPROGRESS);
        this.deploymentFile = deploymentFile;
        this.updateReport = report;
        try {
            this.config = report.getConfiguration();
            this.updateConfiguration(deploymentFile, name);
            if (report.getStatus() != ConfigurationUpdateStatus.FAILURE) {
                report.setStatus(ConfigurationUpdateStatus.SUCCESS);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("IOException when trying to read xml file for type " + this.type + " component " + name), (Throwable)e);
            report.setErrorMessageFromThrowable((Throwable)e);
        }
        catch (JDOMException e) {
            LOG.error((Object)("JDOMException when trying to read xml file for type " + this.type + " component " + name), (Throwable)e);
            report.setErrorMessageFromThrowable((Throwable)e);
        }
    }

    @Override
    public void updateConfiguration(File deploymentFile, String name, CreateResourceReport report) {
        report.setStatus(CreateResourceStatus.IN_PROGRESS);
        this.deploymentFile = deploymentFile;
        this.createReport = report;
        try {
            this.config = report.getResourceConfiguration();
            this.updateConfiguration(deploymentFile, name);
            if (report.getStatus() != CreateResourceStatus.FAILURE) {
                report.setStatus(CreateResourceStatus.SUCCESS);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to write to a new file", (Throwable)e);
            report.setException((Throwable)e);
        }
        catch (JDOMException e) {
            LOG.error((Object)"Unable to convert resource into xml file elements", (Throwable)e);
            report.setException((Throwable)e);
        }
    }

    void updateConfiguration(File file, String name) throws JDOMException, IOException {
        Document doc;
        this.deploymentFile = file;
        if (this.deploymentFile.exists()) {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(this.deploymentFile);
            this.root = doc.getRootElement();
        } else {
            doc = new Document();
            this.root = new Element(this.rootElementString);
            doc.setRootElement(this.root);
        }
        if (!this.root.getName().equals(this.rootElementString)) {
            throw new RuntimeException(this.rootElementString + " file format exception on [" + this.deploymentFile + "], expected [" + this.rootElementString + "] element but found [" + this.root.getName() + "]");
        }
        Element componentElement = this.findComponentElement(name);
        boolean isNewComponent = false;
        if (componentElement == null) {
            isNewComponent = true;
            componentElement = new Element("mbean");
            Attribute codeAttribute = new Attribute("code", this.code);
            componentElement.setAttribute(codeAttribute);
            this.addNameAttributeToMBeanElement(componentElement, this.getNameProperty());
        } else {
            componentElement.removeContent();
            this.updateIfNameChanged(componentElement);
        }
        this.bindSimplePropertiesToConfiguration(this.dependsProperties, "depends", "optional-attribute-name", componentElement);
        this.bindSimplePropertiesToConfiguration(this.simpleAttributeProperties, "attribute", "name", componentElement);
        PropertyList securityListProperty = this.config.getList(SECURITY_CONF);
        if (securityListProperty != null) {
            Element securityConf = new Element("attribute");
            Attribute secConfAttribute = new Attribute("name", SECURITY_CONF);
            securityConf.setAttribute(secConfAttribute);
            Element security = new Element("security");
            securityConf.addContent((Content)security);
            List roles = securityListProperty.getList();
            for (Property role : roles) {
                PropertyMap roleMap = (PropertyMap)role;
                Map map = roleMap.getMap();
                Element roleElement = new Element(roleMap.getName());
                Set keys = map.keySet();
                for (String key : keys) {
                    PropertySimple attribute = (PropertySimple)map.get(key);
                    if (attribute.getStringValue() == null) continue;
                    Attribute keyAttribute = new Attribute(attribute.getName(), attribute.getStringValue());
                    roleElement.setAttribute(keyAttribute);
                }
                security.addContent((Content)roleElement);
            }
            componentElement.addContent((Content)securityConf);
        }
        if (isNewComponent) {
            this.root.addContent((Content)componentElement);
        }
        this.updateFile(doc);
    }
}

