/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbosscache;

import java.util.HashSet;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;

public class JBossCacheDiscoveryComponent
extends MBeanResourceDiscoveryComponent<JMXComponent> {
    private static final Log log = LogFactory.getLog(JBossCacheDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> context) {
        ResourceContext parentCtx = context.getParentResourceContext();
        JMXComponent gparentComponent = (JMXComponent)parentCtx.getParentResourceComponent();
        Set discovered = super.performDiscovery(context.getDefaultPluginConfiguration(), gparentComponent, context.getResourceType(), false);
        HashSet<DiscoveredResourceDetails> results = new HashSet<DiscoveredResourceDetails>(discovered.size());
        for (DiscoveredResourceDetails detail : discovered) {
            boolean isTreeCache = false;
            String key = detail.getResourceKey();
            if (key.contains("treecache-interceptor=")) {
                isTreeCache = true;
            }
            try {
                ObjectName on = ObjectName.getInstance(key);
                key = on.getDomain();
                key = key + ":";
                Set<String> propKeys = on.getKeyPropertyList().keySet();
                for (String prop : propKeys) {
                    if (prop.contains("cache")) continue;
                    key = key + prop + "=" + on.getKeyProperty(prop);
                    key = key + ",";
                }
                if (key.endsWith(",")) {
                    key = key.substring(0, key.length() - 1);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Translated " + detail.getResourceKey() + " to " + key));
                }
                detail.setResourceKey(key);
                detail.setResourceName(key);
                String descr = "";
                if (isTreeCache) {
                    descr = "Tree";
                }
                descr = descr + "Cache at " + key;
                detail.setResourceDescription(descr);
                Configuration pluginConfiguration = detail.getPluginConfiguration();
                PropertySimple onProp = pluginConfiguration.getSimple("objectName");
                onProp.setStringValue(key);
                PropertySimple isTC = new PropertySimple("isTreeCache", (Object)isTreeCache);
                pluginConfiguration.put((Property)isTC);
                results.add(detail);
            }
            catch (MalformedObjectNameException e) {
                log.warn((Object)("Invalid obectname : " + key));
            }
        }
        return results;
    }
}

