/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbosscache3;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas5.ProfileServiceComponent;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;

public class JBossCacheDetailComponent
implements MeasurementFacet,
OperationFacet,
ProfileServiceComponent<ProfileServiceComponent<?>> {
    public static String JMX_NAME = "jmx-name";
    public static String CACHE_DETAIL_BEAN_NAME = "bean-name";
    public ProfileServiceComponent parentComponent;
    private String beanName;
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<ProfileServiceComponent<?>> resourceContext;

    public void start(ResourceContext<ProfileServiceComponent<?>> context) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = context;
        this.parentComponent = (ProfileServiceComponent)context.getParentResourceComponent();
        EmsConnection connection = this.getEmsConnection();
        this.beanName = context.getPluginConfiguration().getSimple(CACHE_DETAIL_BEAN_NAME).getStringValue();
        this.log.debug((Object)("JBoss Cache " + this.beanName + " was loaded."));
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        try {
            EmsConnection connection = this.parentComponent.getEmsConnection();
            if (connection == null) {
                return AvailabilityType.DOWN;
            }
            boolean up = connection.getBean(this.beanName).isRegistered();
            return up ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Can not determine availability for " + this.beanName + ": " + e));
            }
            return AvailabilityType.DOWN;
        }
    }

    public EmsConnection getEmsConnection() {
        return this.parentComponent.getEmsConnection();
    }

    public ProfileServiceConnection getConnection() {
        return this.parentComponent.getConnection();
    }

    @NotNull
    public ResourceContext<ProfileServiceComponent<?>> getResourceContext() {
        return this.resourceContext;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        EmsConnection connection = this.getEmsConnection();
        EmsBean detailComponent = connection.getBean(this.beanName);
        for (MeasurementScheduleRequest request : metrics) {
            String metricName = request.getName();
            try {
                EmsAttribute atribute = detailComponent.getAttribute(metricName);
                Object value = atribute.refresh();
                if (value == null) continue;
                if (request.getDataType() == DataType.MEASUREMENT) {
                    Double number = ((Number)value).doubleValue();
                    report.addData(new MeasurementDataNumeric(request, number));
                    continue;
                }
                if (request.getDataType() != DataType.TRAIT) continue;
                report.addData(new MeasurementDataTrait(request, value.toString()));
            }
            catch (Exception e) {
                this.log.error((Object)("Failure to collect measurement data for metric " + metricName + " from bean " + detailComponent.getBeanName()), (Throwable)e);
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        boolean availCheck;
        OperationResult result = null;
        try {
            EmsBean detailComponent = this.getEmsConnection().getBean(this.beanName);
            EmsOperation operation = detailComponent.getOperation(name);
            Object obj = operation.invoke(new Object[0]);
            if (obj != null) {
                result = new OperationResult();
                result.getComplexResults().put((Property)new PropertySimple("operationResult", (Object)String.valueOf(obj)));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Failure to invoke operation " + name + " on bean " + this.beanName), (Throwable)e);
        }
        boolean bl = availCheck = name.toLowerCase().equals("stop") || name.toLowerCase().contains("start");
        if (availCheck) {
            this.getResourceContext().getAvailabilityContext().requestAvailabilityCheck();
        }
        return result;
    }
}

