/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatDiscoveryComponent;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ProcessExecutionUtility;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;

public class TomcatServerOperationsDelegate {
    private static final String SERVER_MBEAN_NAME = "Catalina:type=Server";
    private static final long STOP_WAIT_MAX = 150000L;
    private static final long STOP_WAIT_INTERVAL = 10000L;
    private static final long STOP_WAIT_FINAL = 30000L;
    private static final long START_WAIT_MAX = 300000L;
    private static final long START_WAIT_INTERVAL = 10000L;
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String SEPARATOR = "\n-----------------------\n";
    private TomcatServerComponent serverComponent;
    private SystemInfo systemInfo;

    public TomcatServerOperationsDelegate(TomcatServerComponent serverComponent, SystemInfo systemInfo) {
        this.serverComponent = serverComponent;
        this.systemInfo = systemInfo;
    }

    public OperationResult invoke(TomcatServerComponent.SupportedOperations operation, Configuration parameters) throws InterruptedException {
        String message = null;
        switch (operation) {
            case RESTART: {
                message = this.restart();
                break;
            }
            case SHUTDOWN: {
                message = this.shutdown();
                break;
            }
            case START: {
                message = this.start();
                break;
            }
            case STORECONFIG: {
                message = this.storeConfig();
            }
        }
        OperationResult result = new OperationResult(message);
        return result;
    }

    private String start() throws InterruptedException {
        AvailabilityType avail;
        Configuration pluginConfiguration = this.serverComponent.getPluginConfiguration();
        String controlMethod = pluginConfiguration.getSimpleValue("controlMethod", TomcatServerComponent.ControlMethod.SCRIPT.name());
        ProcessExecution processExecution = TomcatServerComponent.ControlMethod.SCRIPT.name().equals(controlMethod) ? this.getScriptStart(pluginConfiguration) : this.getRpmStart(pluginConfiguration);
        long start = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        ProcessExecutionResults results = this.systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        Throwable error = results.getError();
        Integer exitCode = results.getExitCode();
        if (null != error || null != exitCode && 0 != exitCode) {
            String message = "Script returned error or non-zero exit code while starting the Tomcat instance. Exit code [" + exitCode + "]";
            if (null == error) {
                this.log.error((Object)message);
            } else {
                this.log.error((Object)message, error);
            }
            avail = this.serverComponent.getAvailability();
        } else {
            avail = this.waitForServerToStart(start);
        }
        if (avail == AvailabilityType.DOWN) {
            throw new RuntimeException("Server failed to start: " + results.getCapturedOutput());
        }
        return "Server has been started.";
    }

    private ProcessExecution getScriptStart(Configuration pluginConfiguration) {
        ProcessExecution processExecution;
        File startScriptFile = this.serverComponent.getStartScriptPath();
        this.validateScriptFile(startScriptFile, "startScript");
        String prefix = pluginConfiguration.getSimple("scriptPrefix").getStringValue();
        if (prefix == null || prefix.replaceAll("\\s", "").equals("")) {
            processExecution = ProcessExecutionUtility.createProcessExecution((File)startScriptFile);
        } else {
            StringTokenizer prefixTokenizer = new StringTokenizer(prefix);
            String processName = prefixTokenizer.nextToken();
            File prefixProcess = new File(processName);
            processExecution = ProcessExecutionUtility.createProcessExecution((File)prefixProcess);
            while (prefixTokenizer.hasMoreTokens()) {
                String prefixArgument = prefixTokenizer.nextToken();
                processExecution.getArguments().add(prefixArgument);
            }
            String startScriptArgument = startScriptFile.getAbsolutePath();
            processExecution.getArguments().add(startScriptArgument);
        }
        this.initScriptProcessExecution(processExecution, startScriptFile);
        return processExecution;
    }

    private ProcessExecution getRpmStart(Configuration pluginConfiguration) {
        String installationPath = this.serverComponent.getInstallationPath().getPath();
        String rpm = TomcatDiscoveryComponent.isEWSTomcat5(installationPath) ? "tomcat5" : "tomcat6";
        ProcessExecution processExecution = new ProcessExecution("service");
        processExecution.setCheckExecutableExists(false);
        processExecution.setArguments(new ArrayList());
        processExecution.getArguments().add(rpm);
        processExecution.getArguments().add("start");
        LinkedHashMap<String, String> envVars = new LinkedHashMap<String, String>(System.getenv());
        processExecution.setEnvironmentVariables(envVars);
        this.initProcessExecution(processExecution);
        return processExecution;
    }

    private String shutdown() throws InterruptedException {
        String result = this.doShutdown();
        AvailabilityType avail = this.waitForServerToShutdown();
        if (avail == AvailabilityType.UP) {
            throw new RuntimeException("Server failed to shutdown");
        }
        return result;
    }

    private String doShutdown() {
        ProcessExecution processExecution;
        Configuration pluginConfiguration = this.serverComponent.getPluginConfiguration();
        String controlMethod = pluginConfiguration.getSimpleValue("controlMethod", TomcatServerComponent.ControlMethod.SCRIPT.name());
        ProcessExecution processExecution2 = processExecution = TomcatServerComponent.ControlMethod.SCRIPT.name().equals(controlMethod) ? this.getScriptShutdown(pluginConfiguration) : this.getRpmShutdown(pluginConfiguration);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("About to execute the following process: [" + processExecution + "]"));
        }
        ProcessExecutionResults results = this.systemInfo.executeProcess(processExecution);
        this.logExecutionResults(results);
        Throwable error = results.getError();
        Integer exitCode = results.getExitCode();
        if (null != error || null != exitCode && 0 != exitCode) {
            String message = "Script returned error or non-zero exit code while shutting down the Tomcat instance. Exit code [" + exitCode + "]";
            if (null == error) {
                throw new RuntimeException(message);
            }
            throw new RuntimeException(message, error);
        }
        return "Server has been shut down.";
    }

    private ProcessExecution getScriptShutdown(Configuration pluginConfiguration) {
        File shutdownScriptFile = this.serverComponent.getShutdownScriptPath();
        this.validateScriptFile(shutdownScriptFile, "shutdownScript");
        String prefix = pluginConfiguration.getSimple("scriptPrefix").getStringValue();
        ProcessExecution processExecution = ProcessExecutionUtility.createProcessExecution((String)prefix, (File)shutdownScriptFile);
        this.initScriptProcessExecution(processExecution, shutdownScriptFile);
        return processExecution;
    }

    private ProcessExecution getRpmShutdown(Configuration pluginConfiguration) {
        String installationPath = this.serverComponent.getInstallationPath().getPath();
        String rpm = TomcatDiscoveryComponent.isEWSTomcat5(installationPath) ? "tomcat5" : "tomcat6";
        ProcessExecution processExecution = new ProcessExecution("service");
        processExecution.setCheckExecutableExists(false);
        processExecution.setArguments(new ArrayList());
        processExecution.getArguments().add(rpm);
        processExecution.getArguments().add("stop");
        LinkedHashMap<String, String> envVars = new LinkedHashMap<String, String>(System.getenv());
        this.log.info((Object)("Operation Envs: " + envVars));
        processExecution.setEnvironmentVariables(envVars);
        this.initProcessExecution(processExecution);
        return processExecution;
    }

    public static void setProcessExecutionEnvironment(ProcessExecution processExecution, String installationPath) {
        LinkedHashMap<String, String> processExecutionEnvironmentVariables;
        String javaHomeDir = System.getProperty("java.home");
        if (null == javaHomeDir) {
            throw new IllegalStateException("The JAVA_HOME environment variable must be set in order to run the Tomcat start or stop script.");
        }
        if (javaHomeDir.endsWith("jre")) {
            javaHomeDir = javaHomeDir.substring(0, javaHomeDir.length() - 3);
        }
        if (null == (processExecutionEnvironmentVariables = processExecution.getEnvironmentVariables())) {
            processExecutionEnvironmentVariables = new LinkedHashMap<String, String>();
            processExecution.setEnvironmentVariables(processExecutionEnvironmentVariables);
        }
        processExecutionEnvironmentVariables.put("JAVA_HOME", new File(javaHomeDir).getPath());
        processExecutionEnvironmentVariables.put("CATALINA_HOME", installationPath);
        processExecutionEnvironmentVariables.put("CATALINA_BASE", installationPath);
        processExecutionEnvironmentVariables.put("CATALINA_TMPDIR", installationPath + File.separator + "temp");
    }

    private void initScriptProcessExecution(ProcessExecution processExecution, File scriptFile) {
        processExecution.setWorkingDirectory(scriptFile.getParent());
        String installationPath = this.serverComponent.getPluginConfiguration().getSimple("installationPath").getStringValue();
        TomcatServerOperationsDelegate.setProcessExecutionEnvironment(processExecution, installationPath);
        this.initProcessExecution(processExecution);
    }

    private void initProcessExecution(ProcessExecution processExecution) {
        processExecution.setCaptureOutput(true);
        processExecution.setWaitForCompletion(1000L);
        processExecution.setKillOnTimeout(false);
    }

    private void logExecutionResults(ProcessExecutionResults results) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Exit code from process execution: " + results.getExitCode()));
            this.log.debug((Object)("Output from process execution: \n-----------------------\n" + results.getCapturedOutput() + SEPARATOR));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String restart() {
        StringBuffer result = new StringBuffer();
        boolean problem = false;
        try {
            this.shutdown();
        }
        catch (Exception e) {
            problem = true;
            result.append("Shutdown may have failed: ");
            result.append(e);
            result.append(", ");
        }
        finally {
            try {
                AvailabilityType avail = this.waitForServerToShutdown();
                if (avail == AvailabilityType.UP) {
                    problem = true;
                    result.append("Shutdown may have failed (server appears to still be running), ");
                }
                this.start();
            }
            catch (Exception e) {
                problem = true;
                result.append("Startup may have failed: ");
                result.append(e);
                result.append(", ");
            }
        }
        if (problem) {
            result.append("Restart may have failed.");
        } else {
            result.append("Server has been restarted.");
        }
        return result.toString();
    }

    private void validateScriptFile(File scriptFile, String scriptPropertyName) {
        if (!scriptFile.exists()) {
            throw new RuntimeException("Script (" + scriptFile + ") specified via '" + scriptPropertyName + "' connection property does not exist.");
        }
        if (scriptFile.isDirectory()) {
            throw new RuntimeException("Script (" + scriptFile + ") specified via '" + scriptPropertyName + "' connection property is a directory, not a file.");
        }
    }

    private AvailabilityType waitForServerToStart(long start) throws InterruptedException {
        AvailabilityType avail;
        while ((avail = this.serverComponent.getAvailability()) == AvailabilityType.DOWN && System.currentTimeMillis() < start + 300000L) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {}
        }
        return avail;
    }

    private AvailabilityType waitForServerToShutdown() {
        for (long wait = 0L; wait < 150000L && AvailabilityType.UP == this.serverComponent.getAvailability(); wait += 10000L) {
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverComponent.getAvailability();
    }

    private String storeConfig() {
        EmsConnection connection = this.serverComponent.getEmsConnection();
        if (connection == null) {
            throw new RuntimeException("Can not connect to the server");
        }
        EmsBean bean = connection.getBean(SERVER_MBEAN_NAME);
        EmsOperation operation = bean.getOperation("storeConfig");
        operation.invoke(new Object[0]);
        return "Tomcat configuration updated.";
    }
}

