/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.plugins.tomcat;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.plugins.tomcat.TomcatServerComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.EmsBeanName;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatConnectorDiscoveryComponent
extends MBeanResourceDiscoveryComponent<TomcatServerComponent> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<TomcatServerComponent> context) {
        ObjectNameQueryUtility queryUtility;
        Set resourceDetails = super.discoverResources(context, false);
        EmsConnection connection = ((TomcatServerComponent)context.getParentResourceComponent()).getEmsConnection();
        List grpBeans = connection.queryBeans((queryUtility = new ObjectNameQueryUtility("Catalina:type=GlobalRequestProcessor,name=%name%")).getTranslatedQuery());
        if (grpBeans.size() != resourceDetails.size()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Connector discovery pending jboss.web:type=GlobalRequestProcessor,name=* deployment...");
            }
            return Collections.emptySet();
        }
        HashMap<String, ConfigInfo> configMap = new HashMap<String, ConfigInfo>(grpBeans.size());
        for (EmsBean bean : grpBeans) {
            ConfigInfo configInfo = new ConfigInfo(bean);
            if (null != configInfo.getPort()) {
                configMap.put(configInfo.port, configInfo);
                continue;
            }
            this.log.warn((Object)("Failed to parse ObjectName for GlobalRequestProcessor: " + configInfo.getName() + ": " + configInfo.getException()));
        }
        for (DiscoveredResourceDetails resource : resourceDetails) {
            String address;
            Configuration pluginConfiguration = resource.getPluginConfiguration();
            String port = pluginConfiguration.getSimple("port").getStringValue();
            ConfigInfo configInfo = (ConfigInfo)configMap.get(port);
            String handler = null != configInfo ? configInfo.getHandler() : "?";
            resource.setResourceName(resource.getResourceName().replace("{handler}", handler));
            pluginConfiguration.put((Property)new PropertySimple("handler", (Object)handler));
            String string = address = null != configInfo ? configInfo.getAddress() : null;
            if (null != address && !"".equals(address.trim())) {
                pluginConfiguration.put((Property)new PropertySimple("address", (Object)address));
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Found a connector: " + handler + (null != configInfo ? "-" + configInfo.getAddress() : "") + "-" + port));
        }
        return resourceDetails;
    }

    private static class ConfigInfo {
        private String name;
        private String address;
        private String handler;
        private String port;
        private Exception exception;

        public ConfigInfo(EmsBean bean) {
            EmsBeanName eName = bean.getBeanName();
            this.name = eName.getKeyProperty("name");
            try {
                int firstDash = this.name.indexOf(45);
                int lastDash = this.name.lastIndexOf(45);
                this.handler = this.name.substring(0, firstDash);
                this.port = this.name.substring(lastDash + 1);
                Integer.valueOf(this.port);
                if (firstDash != lastDash) {
                    String rawAddress = this.name.substring(firstDash + 1, lastDash);
                    int delim = rawAddress.indexOf("%2F");
                    this.address = -1 == delim ? rawAddress : rawAddress.substring(0, delim);
                }
            }
            catch (Exception e) {
                this.port = null;
                this.address = null;
                this.handler = null;
                this.exception = e;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getHandler() {
            return this.handler;
        }

        public String getPort() {
            return this.port;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

