/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.event.ActionBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.util.JavaEnvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntAction
extends ActionBase {
    private static final long serialVersionUID = 3258131345250005557L;
    public static final String ANTACTIONS = "antactions";
    public static final String ANTACTION = "antaction";
    public static final String ANTCALL = "antcall";
    private boolean quiet = false;
    private boolean verbose = false;
    private Properties properties = new Properties();
    private List<String> targets = new ArrayList<String>();
    private List<String> uninstallTargets = new ArrayList<String>();
    private String logFile = null;
    private String buildFile = null;
    private List<String> propertyFiles = new ArrayList<String>();

    public void performInstallAction() throws Exception {
        this.performAction(false);
    }

    public void performUninstallAction() throws Exception {
        this.performAction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(boolean bl) throws Exception {
        if (this.verbose) {
            System.out.println("Calling ANT with buildfile: " + this.buildFile);
        }
        SecurityManager securityManager = null;
        if (!JavaEnvUtils.isJavaVersion("1.0") && !JavaEnvUtils.isJavaVersion("1.1")) {
            securityManager = System.getSecurityManager();
        }
        PrintStream printStream = System.err;
        PrintStream printStream2 = System.out;
        try {
            Object object;
            List<String> list;
            Project project = new Project();
            project.setName("antcallproject");
            project.addBuildListener(this.createLogger());
            project.setInputHandler(new DefaultInputHandler());
            project.setSystemProperties();
            this.addProperties(project, this.getProperties());
            this.addPropertiesFromPropertyFiles(project);
            project.fireBuildStarted();
            project.init();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            List<String> list2 = list = bl ? this.uninstallTargets : this.targets;
            if (list.size() > 0) {
                object = null;
                for (String object2 : list) {
                    object = (Ant)project.createTask("ant");
                    ((Ant)object).setAntfile(this.getBuildFile());
                    ((Ant)object).setTarget(object2);
                    arrayList.add(object);
                }
            }
            object = new Target();
            ((Target)object).setName("calltarget");
            for (Ant ant : arrayList) {
                ((Target)object).addTask(ant);
            }
            project.addTarget((Target)object);
            System.setOut(new PrintStream(new DemuxOutputStream(project, false)));
            System.setErr(new PrintStream(new DemuxOutputStream(project, true)));
            project.executeTarget("calltarget");
        }
        finally {
            if (securityManager != null) {
                System.setSecurityManager(securityManager);
            }
            System.setOut(printStream2);
            System.setErr(printStream);
        }
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(String string) {
        this.buildFile = string;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public List<String> getPropertyFiles() {
        return this.propertyFiles;
    }

    public void addPropertyFile(String string) {
        this.propertyFiles.add(string);
    }

    public void setPropertyFiles(List<String> list) {
        this.propertyFiles = list;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public void setTargets(ArrayList<String> arrayList) {
        this.targets = arrayList;
    }

    public void addTarget(String string) {
        this.targets.add(string);
    }

    public List<String> getUninstallTargets() {
        return this.uninstallTargets;
    }

    public void setUninstallTargets(ArrayList<String> arrayList) {
        this.uninstallTargets = arrayList;
    }

    public void addUninstallTarget(String string) {
        this.uninstallTargets.add(string);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    private BuildLogger createLogger() {
        int n = 2;
        if (this.verbose) {
            n = 4;
        } else if (this.quiet) {
            n = 1;
        }
        DefaultLogger defaultLogger = new DefaultLogger();
        defaultLogger.setMessageOutputLevel(n);
        if (this.logFile != null) {
            try {
                PrintStream printStream = new PrintStream(new FileOutputStream(this.logFile, true));
                defaultLogger.setOutputPrintStream(printStream);
                defaultLogger.setErrorPrintStream(printStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                defaultLogger.setOutputPrintStream(System.out);
                defaultLogger.setErrorPrintStream(System.err);
            }
        } else {
            defaultLogger.setOutputPrintStream(System.out);
            defaultLogger.setErrorPrintStream(System.err);
        }
        return defaultLogger;
    }

    private void addProperties(Project project, Properties properties) {
        if (project == null) {
            return;
        }
        if (properties.size() > 0) {
            Iterator<Object> iterator = properties.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                project.setProperty(string, properties.getProperty(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPropertiesFromPropertyFiles(Project project) throws Exception {
        if (project == null) {
            return;
        }
        Properties properties = new Properties();
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            for (String string : this.propertyFiles) {
                file = new File(string);
                if (file.exists()) {
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                    fileInputStream.close();
                    continue;
                }
                throw new Exception("Required propertyfile " + file + " for antcall doesn't exist.");
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        this.addProperties(project, properties);
    }
}

