/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.panels.CheckBoxNode;
import com.izforge.izpack.panels.PartialIcon;
import com.izforge.izpack.panels.TreePacksPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

class CheckBoxNodeRenderer
implements TreeCellRenderer {
    private static final JPanel rendererPanel = new JPanel();
    private static final JLabel packSizeLabel = new JLabel();
    private static final JCheckBox checkbox = new JCheckBox();
    private static final JCheckBox normalCheckBox = new JCheckBox();
    private static final Font normalFont = new JCheckBox().getFont();
    private static final Font boldFont = new Font(normalFont.getFontName(), 1, normalFont.getSize());
    private static final Font plainFont = new Font(normalFont.getFontName(), 0, normalFont.getSize());
    private static final Color annotationColor = new Color(0, 0, 120);
    private static final Color changedColor = new Color(200, 0, 0);
    private static Color selectionForeground;
    private static Color selectionBackground;
    private static Color textForeground;
    private static Color textBackground;
    TreePacksPanel treePacksPanel;
    private boolean showPackSize;

    public CheckBoxNodeRenderer(TreePacksPanel treePacksPanel, boolean bl) {
        this.showPackSize = bl;
        selectionForeground = UIManager.getColor("Tree.selectionForeground");
        selectionBackground = UIManager.getColor("Tree.selectionBackground");
        textForeground = UIManager.getColor("Tree.textForeground");
        textBackground = UIManager.getColor("Tree.textBackground");
        this.treePacksPanel = treePacksPanel;
        int n = treePacksPanel.getTree().getPreferredSize().width;
        int n2 = CheckBoxNodeRenderer.checkbox.getPreferredSize().height;
        int n3 = n - n / 4;
        rendererPanel.setLayout(new BorderLayout(0, 0));
        rendererPanel.setBackground(textBackground);
        rendererPanel.add("West", checkbox);
        if (bl) {
            rendererPanel.setAlignmentX(0.0f);
            rendererPanel.setAlignmentY(0.0f);
            rendererPanel.add("East", packSizeLabel);
        }
        rendererPanel.setMinimumSize(new Dimension(n3, n2));
        rendererPanel.setPreferredSize(new Dimension(n3, n2));
        rendererPanel.setSize(new Dimension(n3, n2));
        rendererPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.treePacksPanel.fromModel();
        if (bl) {
            checkbox.setForeground(selectionForeground);
            checkbox.setBackground(selectionBackground);
            rendererPanel.setForeground(selectionForeground);
            rendererPanel.setBackground(selectionBackground);
            packSizeLabel.setBackground(selectionBackground);
        } else {
            checkbox.setForeground(textForeground);
            checkbox.setBackground(textBackground);
            rendererPanel.setForeground(textForeground);
            rendererPanel.setBackground(textBackground);
            packSizeLabel.setBackground(textBackground);
        }
        if (object != null && object instanceof CheckBoxNode) {
            CheckBoxNode checkBoxNode = (CheckBoxNode)object;
            if (checkBoxNode.isTotalSizeChanged()) {
                packSizeLabel.setForeground(changedColor);
            } else if (bl) {
                packSizeLabel.setForeground(selectionForeground);
            } else {
                packSizeLabel.setForeground(annotationColor);
            }
            checkbox.setText(checkBoxNode.getTranslatedText());
            if (this.showPackSize) {
                packSizeLabel.setText(Pack.toByteUnitsString(checkBoxNode.getTotalSize()));
            }
            if (checkBoxNode.isPartial()) {
                checkbox.setSelected(false);
            } else {
                checkbox.setSelected(checkBoxNode.isSelected());
            }
            checkbox.setEnabled(checkBoxNode.isEnabled());
            packSizeLabel.setEnabled(checkBoxNode.isEnabled());
            if (checkBoxNode.getChildCount() > 0) {
                checkbox.setFont(boldFont);
                packSizeLabel.setFont(boldFont);
            } else {
                checkbox.setFont(normalFont);
                packSizeLabel.setFont(plainFont);
            }
            if (checkBoxNode.isPartial()) {
                checkbox.setIcon(new PartialIcon());
            } else {
                checkbox.setIcon(normalCheckBox.getIcon());
            }
        }
        return rendererPanel;
    }

    public Component getCheckRenderer() {
        return rendererPanel;
    }
}

