/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class SystemLogService
implements LogService {
    private BundleContext context;

    public SystemLogService(BundleContext context) {
        this.context = context;
    }

    public void log(int level, String message) {
        this.logInternal(null, level, message, null);
    }

    public void log(int level, String message, Throwable exception) {
        this.logInternal(null, level, message, exception);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.logInternal(sr, level, message, null);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.logInternal(sr, level, message, exception);
    }

    private void logInternal(ServiceReference sref, int level, String message, Throwable exception) {
        Bundle bundle;
        try {
            bundle = this.context.getBundle();
        }
        catch (IllegalStateException ex) {
            return;
        }
        long time = System.currentTimeMillis();
        String bndStr = bundle.getSymbolicName();
        String srefStr = null;
        if (sref != null && sref.getBundle() != null) {
            srefStr = sref.getBundle().getSymbolicName();
        }
        String t = new SimpleDateFormat("dd-MMM-yyyy HH:mm.ss.SSS").format(new Date(time));
        String l = " " + this.logLevel(level);
        String s = srefStr != null ? ",sref=" + srefStr : "";
        String b = ",bnd=" + bndStr;
        String m = ",msg=" + message;
        String e = exception != null ? ",ex=" + exception : "";
        System.out.println("[" + t + l + b + s + m + e + "]");
        if (exception != null) {
            exception.printStackTrace(System.out);
        }
    }

    private String logLevel(int level) {
        String logLevel;
        switch (level) {
            case 4: {
                logLevel = "DEBUG";
                break;
            }
            case 3: {
                logLevel = "INFO";
                break;
            }
            case 2: {
                logLevel = "WARN";
                break;
            }
            case 1: {
                logLevel = "ERROR";
                break;
            }
            default: {
                logLevel = "Level=" + level;
            }
        }
        return logLevel;
    }
}

