/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.httpservice;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.httpservice.DefaultHttpContext;
import org.jboss.as.osgi.httpservice.HttpServiceFactory;
import org.jboss.as.osgi.httpservice.ResourceServlet;
import org.jboss.as.osgi.httpservice.WebLogger;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.web.host.ApplicationContextWrapper;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.as.web.host.ServletBuilder;
import org.jboss.as.web.host.WebDeploymentBuilder;
import org.jboss.as.web.host.WebDeploymentController;
import org.jboss.as.web.host.WebHost;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

final class HttpServiceImpl
implements HttpService {
    private final HttpServiceFactory.GlobalRegistry registry;
    private final ServerEnvironment serverEnvironment;
    private final CommonWebServer webServer;
    private final WebHost virtualHost;
    private final Bundle bundle;
    private final Map<HttpContext, ShareableContextWrapper> contexts = new WeakHashMap<HttpContext, ShareableContextWrapper>();

    HttpServiceImpl(ServerEnvironment serverEnvironment, CommonWebServer webServer, WebHost virtualHost, Bundle bundle) {
        this.registry = HttpServiceFactory.GlobalRegistry.INSTANCE;
        this.virtualHost = virtualHost;
        this.webServer = webServer;
        this.serverEnvironment = serverEnvironment;
        this.bundle = bundle;
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.validateAlias(alias, false);
        this.validateServlet(servlet);
        this.registerInternal(alias, servlet, initparams, httpContext, HttpServiceFactory.Registration.Type.SERVLET);
    }

    @Override
    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        this.validateAlias(alias, false);
        this.validateName(name);
        if (httpContext == null) {
            httpContext = this.createDefaultHttpContext();
        }
        ResourceServlet servlet = new ResourceServlet(name, httpContext);
        this.registerInternal(alias, (Servlet)servlet, null, null, HttpServiceFactory.Registration.Type.RESOURCE);
    }

    private synchronized ServletBuilder registerInternal(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext, HttpServiceFactory.Registration.Type type) throws NamespaceException {
        WebDeploymentController deploymentController;
        File storageDir = new File(this.serverEnvironment.getServerTempDir() + File.separator + alias + File.separator + "osgiservlet-root");
        storageDir.mkdirs();
        WebDeploymentBuilder deploymentBuilder = new WebDeploymentBuilder();
        ShareableContextWrapper scWrapper = null;
        if (httpContext != null) {
            scWrapper = this.contexts.get(httpContext);
        } else {
            scWrapper = new ShareableContextWrapper();
            httpContext = new DefaultHttpContext(this.bundle);
        }
        if (scWrapper == null) {
            this.contexts.put(httpContext, scWrapper);
        }
        deploymentBuilder.setDocumentRoot(storageDir);
        deploymentBuilder.setContextRoot(alias);
        deploymentBuilder.setApplicationContextWrapper((ApplicationContextWrapper)scWrapper);
        deploymentBuilder.setClassLoader(servlet.getClass().getClassLoader());
        deploymentBuilder.addMimeMapping("html", "text/html");
        deploymentBuilder.addMimeMapping("jpg", "image/jpeg");
        deploymentBuilder.addMimeMapping("png", "image/png");
        deploymentBuilder.addMimeMapping("gif", "image/gif");
        deploymentBuilder.addMimeMapping("css", "text/css");
        deploymentBuilder.addMimeMapping("js", "text/javascript");
        String wrapperName = alias.substring(1);
        ServletBuilder wrapper = new ServletBuilder();
        wrapper.setServletName(wrapperName);
        wrapper.setServlet((Servlet)new SecurityServletWrapper(servlet, httpContext));
        wrapper.setServletClass(servlet.getClass());
        if (initparams != null) {
            Enumeration keys = initparams.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String val = (String)initparams.get(key);
                wrapper.addInitParam(key, val);
            }
        }
        wrapper.setForceInit(true);
        wrapper.addUrlMapping("/*");
        deploymentBuilder.addServlet(wrapper);
        try {
            deploymentController = this.virtualHost.addWebDeployment(deploymentBuilder);
            WebLogger.WEB_LOGGER.registerWebapp(deploymentBuilder.getContextRoot());
            deploymentController.create();
        }
        catch (Exception ex) {
            throw new NamespaceException(WebLogger.WEB_LOGGER.createContextFailed(), ex);
        }
        try {
            deploymentController.start();
        }
        catch (Exception ex) {
            throw new NamespaceException(WebLogger.WEB_LOGGER.startContextFailed(), ex);
        }
        this.registry.register(alias, this.bundle, deploymentController, servlet, type);
        return wrapper;
    }

    @Override
    public void unregister(String alias) {
        try {
            this.validateAlias(alias, true);
        }
        catch (NamespaceException e) {
            WebLogger.WEB_LOGGER.errorf(e, "", new Object[0]);
            return;
        }
        HttpServiceFactory.Registration reg = this.registry.unregister(alias, this.bundle);
        if (reg != null) {
            this.unregisterInternal(reg);
        }
    }

    @Override
    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.bundle);
    }

    void unregisterInternal(HttpServiceFactory.Registration reg) {
        WebDeploymentController context = reg.getContext();
        try {
            context.stop();
        }
        catch (Exception e) {
            WebLogger.WEB_LOGGER.stopContextFailed(e);
        }
        try {
            context.destroy();
        }
        catch (Exception e) {
            WebLogger.WEB_LOGGER.destroyContextFailed(e);
        }
    }

    private void validateAlias(String alias, boolean exists) throws NamespaceException {
        if (alias == null || !alias.startsWith("/")) {
            throw new IllegalArgumentException(OSGiMessages.MESSAGES.invalidServletAlias(alias));
        }
        if (alias.length() > 1 && alias.endsWith("/")) {
            throw new IllegalArgumentException(OSGiMessages.MESSAGES.invalidServletAlias(alias));
        }
        if (exists && !this.registry.exists(alias)) {
            throw new IllegalArgumentException(OSGiMessages.MESSAGES.aliasMappingDoesNotExist(alias));
        }
        if (!exists && this.registry.exists(alias)) {
            throw new NamespaceException(OSGiMessages.MESSAGES.aliasMappingAlreadyExists(alias));
        }
    }

    private void validateName(String name) throws NamespaceException {
        if (name == null || name.length() > 1 && name.endsWith("/")) {
            throw new NamespaceException(OSGiMessages.MESSAGES.invalidResourceName(name));
        }
    }

    private void validateServlet(Servlet servlet) throws ServletException {
        if (this.registry.contains(servlet)) {
            throw new ServletException(OSGiMessages.MESSAGES.servletAlreadyRegistered(servlet.getServletInfo()));
        }
    }

    static class SecurityRequestWrapper
    extends HttpServletRequestWrapper
    implements HttpServletRequest {
        private final String remoteUser;
        private final String authType;

        SecurityRequestWrapper(String remoteUser, String authType, HttpServletRequest request) {
            super(request);
            this.remoteUser = remoteUser;
            this.authType = authType;
        }

        public String getAuthType() {
            return this.authType;
        }

        public String getRemoteUser() {
            return this.remoteUser;
        }
    }

    static class SecurityServletWrapper
    implements Servlet {
        private final HttpContext httpContext;
        private final Servlet delegate;

        SecurityServletWrapper(Servlet servlet, HttpContext ctx) {
            if (servlet == null) {
                throw new NullPointerException();
            }
            this.delegate = servlet;
            if (ctx == null) {
                throw new NullPointerException();
            }
            this.httpContext = ctx;
        }

        public void destroy() {
            this.delegate.destroy();
        }

        public ServletConfig getServletConfig() {
            return this.delegate.getServletConfig();
        }

        public String getServletInfo() {
            return this.delegate.getServletInfo();
        }

        public void init(ServletConfig sc) throws ServletException {
            this.delegate.init(sc);
        }

        public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                String authType;
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                if (!this.httpContext.handleSecurity(httpRequest, httpResponse)) {
                    return;
                }
                Object u = httpRequest.getAttribute("org.osgi.service.http.authentication.remote.user");
                String remoteUser = u instanceof String ? (String)u : null;
                Object a = httpRequest.getAttribute("org.osgi.service.http.authentication.type");
                String string = authType = a instanceof String ? (String)a : null;
                if (remoteUser != null || authType != null) {
                    request = new SecurityRequestWrapper(remoteUser, authType, httpRequest);
                }
            }
            this.delegate.service(request, response);
        }
    }

    static class ShareableContextWrapper
    implements ApplicationContextWrapper {
        private Object sharedContext;

        ShareableContextWrapper() {
        }

        public synchronized Object wrap(Object context) {
            if (this.sharedContext == null) {
                this.sharedContext = context;
            }
            return this.sharedContext;
        }
    }
}

