/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;

public class BundleActivateProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        XBundleRevision brev = (XBundleRevision)depUnit.getAttachment(OSGiConstants.BUNDLE_REVISION_KEY);
        if (brev == null || brev.isFragment()) {
            return;
        }
        ServiceController<XBundle> controller = BundleActivateService.addService(phaseContext.getServiceTarget(), depUnit, brev.getBundle());
        phaseContext.addDependency(controller.getName(), AttachmentKey.create(XBundle.class));
    }

    public void undeploy(DeploymentUnit depUnit) {
    }

    static class BundleActivateService
    implements Service<XBundle> {
        private final InjectedValue<Component> injectedComponent = new InjectedValue();
        private final DeploymentUnit depUnit;
        private final XBundle bundle;

        static ServiceController<XBundle> addService(ServiceTarget serviceTarget, DeploymentUnit depUnit, XBundle bundle2) {
            ServiceName serviceName = depUnit.getServiceName().append(new String[]{"Activate"});
            BundleActivateService service = new BundleActivateService(depUnit, bundle2);
            ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
            OSGiMetaData metadata = (OSGiMetaData)depUnit.getAttachment(OSGiConstants.OSGI_METADATA_KEY);
            if (metadata != null && metadata.getBundleActivator() != null) {
                String activatorClass = metadata.getBundleActivator();
                EEModuleDescription moduleDescription = (EEModuleDescription)depUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
                if (moduleDescription != null) {
                    for (ComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
                        if (!activatorClass.equals(componentDescription.getComponentClassName())) continue;
                        ServiceName startServiceName = componentDescription.getStartServiceName();
                        builder.addDependency(startServiceName, Component.class, service.injectedComponent);
                    }
                }
            }
            builder.addDependencies((Iterable)depUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.BUNDLE_ACTIVE_DEPENDENCIES));
            return builder.install();
        }

        private BundleActivateService(DeploymentUnit depUnit, XBundle bundle2) {
            this.depUnit = depUnit;
            this.bundle = bundle2;
        }

        public void start(StartContext context) throws StartException {
            Deployment deployment = (Deployment)this.depUnit.getAttachment(OSGiConstants.DEPLOYMENT_KEY);
            BundleManager bundleManager = (BundleManager)this.depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
            Component activatorComponent = (Component)this.injectedComponent.getOptionalValue();
            if (activatorComponent != null && deployment.getAttachment(IntegrationConstants.BUNDLE_ACTIVATOR_KEY) == null) {
                ComponentInstance componentInstance = activatorComponent.createInstance();
                BundleActivator instance = (BundleActivator)componentInstance.getInstance();
                deployment.putAttachment(IntegrationConstants.BUNDLE_ACTIVATOR_KEY, (Object)instance);
            }
            if (this.bundle.getState() != 32) {
                try {
                    bundleManager.startBundle(this.bundle, 2);
                    this.depUnit.putAttachment(org.jboss.as.server.deployment.Attachments.BUNDLE_STATE_KEY, (Object)Attachments.BundleState.ACTIVE);
                }
                catch (BundleException ex) {
                    throw OSGiMessages.MESSAGES.cannotStartBundle(ex, (Bundle)this.bundle);
                }
            }
        }

        public void stop(StopContext context) {
            if (this.bundle.getState() == 8 || this.bundle.getState() == 32) {
                try {
                    BundleManager bundleManager = (BundleManager)this.depUnit.getAttachment(OSGiConstants.BUNDLE_MANAGER_KEY);
                    bundleManager.stopBundle(this.bundle, 1);
                    this.depUnit.putAttachment(org.jboss.as.server.deployment.Attachments.BUNDLE_STATE_KEY, (Object)Attachments.BundleState.RESOLVED);
                }
                catch (BundleException ex) {
                    OSGiLogger.LOGGER.debugf(ex, "Cannot stop bundle: %s", this.bundle);
                }
            }
        }

        public XBundle getValue() {
            return this.bundle;
        }
    }
}

