/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import java.util.jar.Manifest;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.service.BundleLifecycleIntegration;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.metadata.OSGiManifestBuilder;

public class OSGiManifestStructureProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Manifest manifest = (Manifest)depUnit.getAttachment(Attachments.OSGI_MANIFEST);
        if (manifest != null) {
            return;
        }
        Deployment dep = BundleLifecycleIntegration.getDeployment(depUnit.getName());
        if (dep != null) {
            manifest = (Manifest)dep.getAttachment(IntegrationConstants.MANIFEST_KEY);
        }
        ResourceRoot deploymentRoot = (ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (manifest == null && deploymentRoot != null) {
            manifest = (Manifest)deploymentRoot.getAttachment(Attachments.MANIFEST);
        }
        if (OSGiManifestBuilder.isValidBundleManifest((Manifest)manifest)) {
            depUnit.putAttachment(Attachments.OSGI_MANIFEST, (Object)manifest);
            depUnit.putAttachment(OSGiConstants.DEPLOYMENT_TYPE_KEY, (Object)OSGiConstants.DeploymentType.Bundle);
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.OSGI_MANIFEST);
    }
}

