/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.osgi.parser.FrameworkPropertyResource;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;

public class OSGiFrameworkPropertyWrite
extends AbstractWriteAttributeHandler<Object> {
    static final OSGiFrameworkPropertyWrite INSTANCE = new OSGiFrameworkPropertyWrite();

    private OSGiFrameworkPropertyWrite() {
        super(new AttributeDefinition[]{FrameworkPropertyResource.VALUE});
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isNormalServer();
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Object> handbackHolder) throws OperationFailedException {
        return this.doUpdate(context, operation, resolvedValue);
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Object handback) throws OperationFailedException {
        this.doUpdate(context, operation, valueToRestore);
    }

    private boolean doUpdate(OperationContext context, ModelNode operation, ModelNode value) {
        String propName = operation.get("address").asObject().get("property").asString();
        String propValue = value.asString();
        SubsystemState subsystemState = SubsystemState.getSubsystemState(context);
        if (subsystemState != null) {
            subsystemState.setProperty(propName, propValue);
        }
        return true;
    }
}

