/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.server.ServerEnvironment;

public final class LayeredBundlePathFactory {
    public static List<File> resolveLayeredBundlePath(ServerEnvironment serverEnvironment) {
        File bundlesDir = serverEnvironment.getBundlesDir();
        if (!bundlesDir.isDirectory()) {
            throw OSGiMessages.MESSAGES.illegalStateCannotFindBundleDir(bundlesDir);
        }
        return LayeredBundlePathFactory.resolveLayeredBundlePath(bundlesDir);
    }

    public static List<File> resolveLayeredBundlePath(File ... bundlePath) {
        ArrayList<File> layeredPath = new ArrayList<File>();
        for (File file : bundlePath) {
            layeredPath.add(file);
            LayersConfig layersConfig = LayeredBundlePathFactory.getLayersConfig(file);
            File layersDir = new File(file, layersConfig.getLayersPath());
            if (!layersDir.exists()) {
                if (!layersConfig.isConfigured()) continue;
                throw OSGiMessages.MESSAGES.illegalStateNoLayersDirectoryFound(layersDir);
            }
            boolean validLayers = true;
            ArrayList<File> layerFiles = new ArrayList<File>();
            for (String layerName : layersConfig.getLayers()) {
                File layer = new File(layersDir, layerName);
                if (!layer.exists()) {
                    if (layersConfig.isConfigured()) {
                        throw OSGiMessages.MESSAGES.illegalStateCannotFindLayer(layerName, layersDir);
                    }
                    validLayers = false;
                    break;
                }
                layerFiles.add(layer);
            }
            if (!validLayers) continue;
            layeredPath.addAll(layerFiles);
            File[] addOns = new File(file, layersConfig.getAddOnsPath()).listFiles();
            if (addOns == null) continue;
            for (File addOn : addOns) {
                if (!addOn.isDirectory()) continue;
                layeredPath.add(addOn);
            }
        }
        return layeredPath;
    }

    private static LayersConfig getLayersConfig(File repoRoot) {
        LayersConfig layersConfig;
        File layersList = new File(repoRoot, "layers.conf");
        if (!layersList.exists()) {
            return new LayersConfig();
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(layersList), "UTF-8");
            Properties props = new Properties();
            props.load(reader);
            layersConfig = new LayersConfig(props);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                LayeredBundlePathFactory.safeClose(reader);
                throw throwable;
            }
        }
        LayeredBundlePathFactory.safeClose(reader);
        return layersConfig;
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class LayersConfig {
        private static final String DEFAULT_LAYERS_PATH = "system/layers";
        private static final String DEFAULT_ADD_ONS_PATH = "system/add-ons";
        private final boolean configured;
        private final String layersPath;
        private final String addOnsPath;
        private final List<String> layers;

        private LayersConfig() {
            this.configured = false;
            this.layersPath = DEFAULT_LAYERS_PATH;
            this.addOnsPath = DEFAULT_ADD_ONS_PATH;
            this.layers = Collections.singletonList("base");
        }

        private LayersConfig(Properties properties) {
            this.configured = true;
            this.layersPath = DEFAULT_LAYERS_PATH;
            this.addOnsPath = DEFAULT_ADD_ONS_PATH;
            boolean excludeBase = false;
            String layersProp = (String)properties.get("layers");
            if (layersProp == null || (layersProp = layersProp.trim()).length() == 0) {
                this.layers = excludeBase ? Collections.emptyList() : Collections.singletonList("base");
            } else {
                String[] layerNames = layersProp.split(",");
                this.layers = new ArrayList<String>();
                boolean hasBase = false;
                for (String layerName : layerNames) {
                    if ("base".equals(layerName)) {
                        hasBase = true;
                    }
                    this.layers.add(layerName);
                }
                if (!hasBase && !excludeBase) {
                    this.layers.add("base");
                }
            }
        }

        boolean isConfigured() {
            return this.configured;
        }

        String getLayersPath() {
            return this.layersPath;
        }

        String getAddOnsPath() {
            return this.addOnsPath;
        }

        List<String> getLayers() {
            return this.layers;
        }
    }
}

