/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.Stack;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.service.StartContext;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.LockManagerPlugin;
import org.jboss.osgi.spi.Attachable;
import org.jboss.osgi.spi.AttachmentKey;

public final class LockManagerIntegration
extends LockManagerPlugin {
    private static AttachmentKey<Stack> LOCK_CONTEXT_KEY = AttachmentKey.create(Stack.class);

    protected LockManager createServiceValue(StartContext startContext) {
        final LockManager delegate = super.createServiceValue(startContext);
        return new LockManager(){

            public <T extends LockManager.LockableItem> T getItemForType(Class<T> type) {
                return (T)delegate.getItemForType(type);
            }

            public LockManager.LockContext getCurrentLockContext() {
                return delegate.getCurrentLockContext();
            }

            public LockManager.LockContext lockItems(LockManager.Method method, LockManager.LockableItem ... items) {
                LockManager.LockContext context = null;
                if (!this.skipLocking(method, items)) {
                    context = delegate.lockItems(method, items);
                    this.pushAttachedLockContext(context, items);
                }
                return context;
            }

            public LockManager.LockContext lockItems(LockManager.Method method, long timeout, TimeUnit unit, LockManager.LockableItem ... items) {
                LockManager.LockContext context = null;
                if (!this.skipLocking(method, items)) {
                    context = delegate.lockItems(method, timeout, unit, items);
                    this.pushAttachedLockContext(context, items);
                }
                return context;
            }

            public void unlockItems(LockManager.LockContext context) {
                this.popAttachedLockContext(context);
                delegate.unlockItems(context);
            }

            private synchronized boolean skipLocking(LockManager.Method method, LockManager.LockableItem ... items) {
                if (this.getCurrentLockContext() != null) {
                    return false;
                }
                LockManager.LockContext context = null;
                for (LockManager.LockableItem item : items) {
                    LockManager.LockContext aux;
                    if (!(item instanceof Attachable)) continue;
                    Attachable attachableItem = (Attachable)item;
                    Stack stack = (Stack)attachableItem.getAttachment(LOCK_CONTEXT_KEY);
                    LockManager.LockContext lockContext = aux = stack != null && !stack.isEmpty() ? (LockManager.LockContext)stack.peek() : null;
                    if (context == null && aux != null) {
                        context = aux;
                    }
                    if (context == aux) continue;
                    return false;
                }
                if (context == null) {
                    return false;
                }
                if (context.getMethod() == LockManager.Method.UPDATE && (method == LockManager.Method.STOP || method == LockManager.Method.INSTALL || method == LockManager.Method.START)) {
                    return true;
                }
                if (context.getMethod() == LockManager.Method.REFRESH && (method == LockManager.Method.STOP || method == LockManager.Method.UNINSTALL || method == LockManager.Method.INSTALL || method == LockManager.Method.START)) {
                    return true;
                }
                return context.getMethod() == LockManager.Method.UNINSTALL && (method == LockManager.Method.STOP || method == LockManager.Method.UNINSTALL);
            }

            private synchronized void pushAttachedLockContext(LockManager.LockContext context, LockManager.LockableItem ... items) {
                for (LockManager.LockableItem item : items) {
                    if (!(item instanceof Attachable)) continue;
                    Attachable attachableItem = (Attachable)item;
                    Stack<LockManager.LockContext> stack = (Stack<LockManager.LockContext>)attachableItem.getAttachment(LOCK_CONTEXT_KEY);
                    if (stack == null) {
                        stack = new Stack<LockManager.LockContext>();
                        attachableItem.putAttachment(LOCK_CONTEXT_KEY, stack);
                    }
                    stack.push(context);
                }
            }

            private synchronized void popAttachedLockContext(LockManager.LockContext context) {
                if (context != null) {
                    for (LockManager.LockableItem item : context.getItems()) {
                        if (!(item instanceof Attachable)) continue;
                        Attachable attachableItem = (Attachable)item;
                        Stack stack = (Stack)attachableItem.getAttachment(LOCK_CONTEXT_KEY);
                        if (stack.size() == 1) {
                            attachableItem.removeAttachment(LOCK_CONTEXT_KEY);
                            continue;
                        }
                        stack.pop();
                    }
                }
            }
        };
    }
}

