/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.service.LayeredBundlePathFactory;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.repository.RepositoryLogger;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.RepositoryResolutionException;
import org.jboss.osgi.repository.URLResourceBuilderFactory;
import org.jboss.osgi.repository.spi.ModuleIdentityRepository;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public final class ModuleIdentityRepositoryIntegration
extends ModuleIdentityRepository {
    private final List<File> bundlesPath;
    private final File modulesDir;

    public ModuleIdentityRepositoryIntegration(ServerEnvironment serverEnvironment) {
        super(Module.getCallerModuleLoader());
        File bundlesDir = serverEnvironment.getBundlesDir();
        if (!bundlesDir.isDirectory()) {
            throw OSGiMessages.MESSAGES.illegalStateArtifactBaseLocation(bundlesDir);
        }
        this.modulesDir = new File(bundlesDir.getParent() + File.separator + "modules");
        if (!this.modulesDir.isDirectory()) {
            throw OSGiMessages.MESSAGES.illegalStateArtifactBaseLocation(this.modulesDir);
        }
        this.bundlesPath = LayeredBundlePathFactory.resolveLayeredBundlePath(serverEnvironment);
    }

    public Collection<Capability> findProviders(Requirement req) {
        String namespace = req.getNamespace();
        if (!"module.identity".equals(namespace)) {
            return Collections.emptyList();
        }
        String idspec = (String)req.getAttributes().get("module.identity");
        if (idspec == null) {
            throw RepositoryMessages.MESSAGES.cannotObtainRequiredAttribute("module.identity");
        }
        ArrayList<XIdentityCapability> result = new ArrayList<XIdentityCapability>();
        try {
            ModuleIdentifier moduleId = ModuleIdentifier.fromString((String)idspec);
            File contentFile = this.getRepositoryEntry(this.bundlesPath, moduleId);
            if (contentFile != null) {
                URL contentURL = contentFile.toURI().toURL();
                XResourceBuilder builder = URLResourceBuilderFactory.create((URL)contentURL, null);
                builder.addCapability("module.identity", idspec);
                XResource resource = builder.getResource();
                try {
                    resource = this.getTargetResource(resource);
                    result.add(resource.getIdentityCapability());
                }
                catch (Exception ex) {
                    RepositoryLogger.LOGGER.errorCannotCreateResource((Throwable)ex, idspec);
                }
            } else {
                Collection providers = super.findProviders(req);
                result.addAll(providers);
            }
        }
        catch (RepositoryResolutionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RepositoryResolutionException((Throwable)ex);
        }
        return Collections.unmodifiableList(result);
    }

    public File getRepositoryEntry(List<File> basePaths, ModuleIdentifier moduleId) throws IOException {
        String identifierPath = this.getModuleIdAsPath(moduleId);
        for (File basePath : basePaths) {
            File contentFile = this.getSingleJarEntry(basePath, identifierPath);
            if (contentFile == null) continue;
            return contentFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSGiMetaData getOSGiMetaData(XResource resource) throws IOException {
        OSGiMetaData result = null;
        ModuleIdentifier moduleId = this.getModuleIdentifier(resource);
        Path basePath = FileSystems.getDefault().getPath(this.modulesDir.getAbsolutePath(), "system", "layers", "base");
        String identifierPath = moduleId.getName().replace('.', File.separatorChar) + File.separator + moduleId.getSlot();
        File entryFile = FileSystems.getDefault().getPath(basePath.toString(), identifierPath, "jbosgi-xservice.properties").toFile();
        if (entryFile.exists()) {
            try (FileInputStream input = new FileInputStream(entryFile);){
                Properties props = new Properties();
                props.load(input);
                result = OSGiMetaDataBuilder.load((Properties)props);
            }
            catch (IOException ex) {
                OSGiLogger.LOGGER.debugf("Cannot load OSGi metadata from: %s", entryFile);
            }
        }
        if (result == null) {
            result = this.getOSGiMetaDataFromManifest(resource);
        }
        if (result == null) {
            Module module = this.loadModule(moduleId);
            result = this.getOSGiMetaDataFromModule(module);
        }
        return result;
    }

    private File getSingleJarEntry(File baseDir, String identifierPath) throws IOException {
        File entryDir = FileSystems.getDefault().getPath(baseDir.getAbsolutePath(), identifierPath).toFile();
        if (!entryDir.isDirectory()) {
            OSGiLogger.LOGGER.tracef("Cannot obtain directory: %s", entryDir);
            return null;
        }
        String[] files = entryDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files.length == 0) {
            OSGiLogger.LOGGER.tracef("Cannot find jar in: %s", entryDir);
            return null;
        }
        if (files.length > 1) {
            OSGiLogger.LOGGER.tracef("Multiple jars in: %s", entryDir);
            return null;
        }
        File entryFile = new File(entryDir + "/" + files[0]);
        if (!entryFile.exists()) {
            OSGiLogger.LOGGER.tracef("File does not exist: %s", entryFile);
            return null;
        }
        return entryFile;
    }

    private String getModuleIdAsPath(ModuleIdentifier moduleIdentifier) {
        return moduleIdentifier.getName().replace('.', '/') + "/" + moduleIdentifier.getSlot();
    }
}

