/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.IOException;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.AbstractBundleRevisionAdaptor;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.ResourceInstaller;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.spi.AbstractResourceInstaller;
import org.jboss.osgi.repository.spi.ModuleIdentityRepository;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XBundleRevisionBuilder;
import org.jboss.osgi.resolver.XBundleRevisionBuilderFactory;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class ResourceInstallerService
extends AbstractResourceInstaller
implements Service<ResourceInstaller> {
    public static final ServiceName SERVICE_NAME = OSGiConstants.SERVICE_BASE_NAME.append(new String[]{"ResourceInstaller"});
    private final InjectedValue<XRepository> injectedRepository = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();

    public static ServiceController<ResourceInstaller> addService(ServiceTarget target) {
        ResourceInstallerService service = new ResourceInstallerService();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(OSGiConstants.REPOSITORY_SERVICE_NAME, XRepository.class, service.injectedRepository);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, service.injectedEnvironment);
        return builder.install();
    }

    private ResourceInstallerService() {
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public ResourceInstaller getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public XBundle installModuleResource(final BundleContext context, XResource res) throws BundleException {
        XIdentityCapability icap = res.getIdentityCapability();
        if (!icap.getNamespace().equals("osgi.identity")) {
            throw RepositoryMessages.MESSAGES.unsupportedResource(res);
        }
        String idspec = (String)icap.getAttribute("module.identity");
        ModuleIdentifier moduleId = ModuleIdentifier.fromString((String)idspec);
        XRepository repository = (XRepository)this.injectedRepository.getValue();
        ModuleIdentityRepository moduleRepository = (ModuleIdentityRepository)repository.adapt(ModuleIdentityRepository.class);
        final Module module = moduleRepository.loadModule(moduleId);
        XBundleRevisionBuilderFactory factory = new XBundleRevisionBuilderFactory(){

            public XBundleRevision createResource() {
                return new AbstractBundleRevisionAdaptor(context, module);
            }
        };
        XBundleRevisionBuilder builder = XBundleRevisionBuilderFactory.create((XBundleRevisionBuilderFactory)factory);
        for (Capability cap : res.getCapabilities(null)) {
            builder.addCapability(cap.getNamespace(), cap.getAttributes(), cap.getDirectives());
        }
        for (Requirement req : res.getRequirements(null)) {
            builder.addRequirement(req.getNamespace(), req.getAttributes(), req.getDirectives());
        }
        XBundleRevision brev = (XBundleRevision)builder.getResource();
        try {
            OSGiMetaData metadata = moduleRepository.getOSGiMetaData((XResource)brev);
            brev.putAttachment(IntegrationConstants.OSGI_METADATA_KEY, (Object)metadata);
        }
        catch (IOException e) {
            throw RepositoryMessages.MESSAGES.cannotObtainResourceMetadata((XResource)brev);
        }
        XEnvironment environment = (XEnvironment)this.injectedEnvironment.getValue();
        environment.installResources(new XResource[]{brev});
        return brev.getBundle();
    }
}

