/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.deployment;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.portal.test.framework.deployment.Deployment;
import org.jboss.portal.test.framework.server.Node;

public class Deployer {
    private static final Logger log = Logger.getLogger(Deployer.class);
    private Map<URL, Deployment> deployments;

    public void create() {
    }

    public void start() {
        this.deployments = new HashMap<URL, Deployment>();
    }

    public void stop() {
        for (URL url : new ArrayList<URL>(this.deployments.keySet())) {
            this.undeploy(url);
        }
        this.deployments = null;
    }

    public void destroy() {
    }

    public void deploy(String parentName, String childName, Node node) throws Exception {
        this.deploy(parentName, childName, new Node[]{node});
    }

    public void deploy(File parent, String childName, Node node) throws Exception {
        this.deploy(parent, childName, new Node[]{node});
    }

    public void deploy(String parentName, String childName, Node[] nodes) throws Exception {
        this.deploy(new File(parentName), childName, nodes);
    }

    public void deploy(File parent, String childName, Node[] nodes) throws Exception {
        File file = new File(parent, childName);
        if (!file.exists()) {
            String msg = "Cannot deploy inexisting file " + file.getAbsolutePath();
            log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        this.deploy(file.toURL(), nodes);
    }

    public void deploy(String url, Node node) throws Exception {
        this.deploy(url, new Node[]{node});
    }

    public void deploy(URL url, Node node) throws Exception {
        this.deploy(url, new Node[]{node});
    }

    public void deploy(URL url, Node[] nodes) throws Exception {
        Deployment deployment = new Deployment(nodes, url);
        deployment.deploy();
        this.deployments.put(url, deployment);
    }

    public void deploy(String url, Node[] nodes) throws Exception {
        this.deploy(new URL(url), nodes);
    }

    public void undeploy(URL url) {
        Deployment deployment = this.deployments.remove(url);
        if (deployment != null) {
            deployment.undeploy();
        }
    }

    public void undeploy(String parentName, String childName) throws Exception {
        this.undeploy(new File(parentName), childName);
    }

    public void undeploy(File parent, String childName) throws Exception {
        this.undeploy(new File(parent, childName).toURL());
    }

    public void undeploy(String url) throws Exception {
        this.undeploy(new URL(url));
    }
}

