/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.embedded.opends;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.opends.server.tools.LDAPCompare;
import org.opends.server.tools.LDAPDelete;
import org.opends.server.tools.LDAPModify;
import org.opends.server.tools.LDAPSearch;

public class OpenDSUtil {
    private static final Logger log = Logger.getLogger(OpenDSUtil.class);

    public boolean addLDIF(String serverHost, String port, String admin, String adminpwd, URL ldifURL) {
        File ldifFile = new File(ldifURL.getPath());
        if (!ldifFile.exists()) {
            throw new IllegalArgumentException("LDIF file:" + ldifURL + " does not exist");
        }
        String[] cmd = new String[]{"-h", serverHost, "-p", port, "-D", admin, "-w", adminpwd, "-a", "-f", ldifFile.getPath()};
        log.debug((Object)("addLDIF:" + this.print(cmd)));
        return LDAPModify.mainModify((String[])cmd, (boolean)false, (OutputStream)System.out, (OutputStream)System.err) == 0;
    }

    public boolean deleteDN(String serverHost, String port, String admin, String adminpwd, String dnToDelete, boolean recursive) {
        String rec = recursive ? "-x" : " ";
        String[] cmd = new String[]{"-h", serverHost, "-p", port, "-D", admin, "-w", adminpwd, rec, dnToDelete};
        log.debug((Object)("deleteDN:" + this.print(cmd)));
        return LDAPDelete.mainDelete((String[])cmd, (boolean)false, (OutputStream)System.out, (OutputStream)System.err) == 0;
    }

    public boolean existsDN(String serverHost, String port, String dn) {
        String[] cmd = new String[]{"-h", serverHost, "-p", port, "-b", dn, "-s", "sub", "objectclass=*"};
        log.debug((Object)("existsDN:" + this.print(cmd)));
        return LDAPSearch.mainSearch((String[])cmd, (boolean)false, (OutputStream)System.out, (OutputStream)System.err) == 0;
    }

    public boolean ldapCompare(String cmdline) {
        String[] strArr = this.getStringArr(cmdline);
        log.debug((Object)("ldapCompare:" + this.print(strArr)));
        return LDAPCompare.mainCompare((String[])strArr, (boolean)false, (OutputStream)System.out, (OutputStream)System.err) == 0;
    }

    public boolean ldapDelete(String cmdline) {
        String[] strArr = this.getStringArr(cmdline);
        log.debug((Object)("ldapDelete:" + this.print(strArr)));
        return LDAPDelete.mainDelete((String[])strArr, (boolean)false, (OutputStream)System.out, (OutputStream)System.err) == 0;
    }

    public boolean ldapModify(String cmdline) {
        String[] strArr = this.getStringArr(cmdline);
        log.debug((Object)("ldapModify:" + this.print(strArr)));
        return LDAPModify.mainModify((String[])strArr, (boolean)false, (OutputStream)System.out, (OutputStream)System.err) == 0;
    }

    private String[] getStringArr(String str) {
        StringTokenizer st = new StringTokenizer(str);
        int num = st.countTokens();
        String[] strarr = new String[num];
        int i = 0;
        while (st.hasMoreTokens()) {
            strarr[i++] = st.nextToken();
        }
        return strarr;
    }

    private String print(String[] arr) {
        StringBuffer sb = new StringBuffer();
        int len = arr != null ? arr.length : 0;
        for (int i = 0; i < len; ++i) {
            sb.append(arr[i]);
        }
        return sb.toString();
    }
}

