/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.portal.test.framework.server.Node;
import org.jboss.portal.test.framework.server.NodeId;

public class NodeManager {
    private final Map nodeMap = new HashMap();

    public NodeManager(List nodes) {
        for (Node node : nodes) {
            this.nodeMap.put(node.getId(), node);
        }
    }

    public Collection getNodes() {
        return this.nodeMap.values();
    }

    public Node[] getNodes(NodeId[] nodeIds) {
        if (nodeIds == null) {
            throw new IllegalArgumentException("No null node ids accepted");
        }
        Node[] nodes = new Node[nodeIds.length];
        for (int i = 0; i < nodeIds.length; ++i) {
            NodeId nodeId = nodeIds[i];
            if (nodeId == null) {
                throw new IllegalArgumentException("No null node id accepted");
            }
            nodes[i] = this.getNode(nodeId);
        }
        return nodes;
    }

    public Node getNode(NodeId nodeId) {
        if (nodeId == null) {
            throw new IllegalArgumentException("No null node id accepted");
        }
        return (Node)this.nodeMap.get(nodeId);
    }
}

