/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.plugins.deploy.actions;

import org.jboss.profileservice.management.actions.AbstractTwoPhaseModificationAction;
import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.VirtualDeploymentRepositoryExt;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.action.deployment.DeploymentAction;
import org.jboss.profileservice.spi.action.deployment.DeploymentActionContext;
import org.jboss.profileservice.spi.managed.ManagedProfile;
import org.jboss.profileservice.spi.repository.ArtifactId;
import org.jboss.profileservice.spi.repository.ArtifactRepository;
import org.jboss.profileservice.spi.repository.MutableArtifactRepository;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public class DeploymentRemoveAction extends AbstractTwoPhaseModificationAction<DeploymentActionContext>
   implements DeploymentAction<DeploymentActionContext>
{

   private String deploymentName;
   private ManagedProfile managed;
   
   public DeploymentRemoveAction(ManagedProfile managed, String deploymentName,
            DeploymentActionContext modificationContext)
   {
      super(modificationContext);
      this.managed = managed;
      this.deploymentName = deploymentName;
   }

   protected void doCancel()
   {
      // FIXME doCancel
   }

   protected void doCommit(ProfileModificationResponse response)
   {
      // FIXME doCommit
   }

   protected void doComplete(ProfileModificationResponse response) throws Exception
   {
      // FIXME doComplete
   }

   protected boolean doPrepare(ProfileModificationResponse response)
   {
      try
      {
         if(managed.getProfile().isMutable() == false || managed.getProfile() instanceof MutableProfile == false)
         {
            return false;
         }
         final MutableProfile profile = MutableProfile.class.cast(managed.getProfile());
         final ProfileDeployment deployment = profile.getDeployment(deploymentName);
         
         final ArtifactId artifactId = resolveArtifactMetaData(deployment);
         // In case there is no artifact we just remove it from the profile
         if(artifactId != null)
         {
            MutableArtifactRepository<ArtifactId> repository = resolveArtifactRepository(profile, deployment);
            if(repository != null)
            {
               repository.removeArtifact(artifactId);
            }
         }
         // Remove the deployment from the profile
         profile.removeDeployment(deployment.getName());
         
         // Notify
         response.fireModificationEvent(ProfileModificationEvent.create(ProfileModificationType.DELETE, managed.getProfileKey()));
      }
      catch(Exception e)
      {
         response.setFailure(e);
         return false;
      }
      return true;
   }

   protected void doRollbackFromActive()
   {
      // FIXME doRollbackFromActive
   }

   protected void doRollbackFromCancelled()
   {
      // FIXME doRollbackFromCancelled
   }

   protected void doRollbackFromComplete()
   {
      // FIXME doRollbackFromComplete
   }

   protected void doRollbackFromPrepared()
   {
      // FIXME doRollbackFromPrepared
   }

   protected void doRollbackFromRollbackOnly()
   {
      // FIXME doRollbackFromRollbackOnly
   }

   MutableArtifactRepository<ArtifactId> resolveArtifactRepository(MutableProfile profile, ProfileDeployment deployment)
   {
      VirtualDeploymentRepository deploymentRepository = resolveVirtualDeploymentRepository(profile);
      if(deploymentRepository == null)
      {
         return null;
      }
      ArtifactId artifactId = resolveArtifactMetaData(deployment);
      if(artifactId == null) 
      {
         return null;
      }
      ArtifactRepository<ArtifactId> repository = deploymentRepository.resolveArtifactRepository(artifactId);
      if(repository != null && repository instanceof MutableArtifactRepository<?>)
      {
         return MutableArtifactRepository.class.cast(repository);
      }
      return null; 
   }
   
   VirtualDeploymentRepository resolveVirtualDeploymentRepository(MutableProfile profile)
   {
      if(profile instanceof VirtualDeploymentRepositoryExt)
      {
         return VirtualDeploymentRepositoryExt.class.cast(profile).getDeploymentRepository();
      }
      return null;
   }
   
   ArtifactId resolveArtifactMetaData(ProfileDeployment deployment)
   {
      return deployment.getDeploymentInfo().getMetaData().getArtifact();
   }
   
}

