/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.plugins.deploy.actions;

import java.util.Collection;

import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.action.deployment.DeploymentAction;
import org.jboss.profileservice.spi.action.deployment.DeploymentActionContext;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentInfo;
import org.jboss.profileservice.spi.managed.ManagedProfile;
import org.jboss.profileservice.spi.managed.ManagedProfileDeployer;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public class DeploymentStopAction extends AbstractDeploymentLifeCycleAction implements DeploymentAction<DeploymentActionContext>
{

   public DeploymentStopAction(ManagedProfile managed, Collection<String> names,
         DeploymentActionContext modificationContext)
   {
      super(managed, names, modificationContext);
   }

   protected void doCancel()
   {
      // 
   }

   protected void doCommit(ProfileModificationResponse response)
   {
      for(DeploymentState state : getDeployments())
      {
         ProfileDeploymentInfo info = state.getDeployment().getDeploymentInfo();
         // Mark as undeployed
         info.clearFlag(ProfileDeploymentFlag.DEPLOYED);
      }
   }

   protected void doComplete(ProfileModificationResponse response) throws Exception
   {
      //
   }

   protected boolean doPrepare(ProfileModificationResponse response)
   {
      try
      {
         final Profile profile = getManagedProfile().getProfile();
         final ManagedProfileDeployer deployer = getManagedProfile().getManagedDeployer();
         for(String deploymentName : getDeploymentNames())
         {
            ProfileDeployment deployment = profile.getDeployment(deploymentName);
            ProfileDeploymentInfo info = deployment.getDeploymentInfo();
            info.setFlag(ProfileDeploymentFlag.LOCKED);
            // Remove from deployer
            deployer.removeDeployment(deployment);
            // Add to the deployment list
            addDeployment(deployment);
         }

         // Process
         deployer.process();
         
         // Notify
         response.fireModificationEvent(ProfileModificationEvent.create(ProfileModificationType.DELETE, getManagedProfile().getProfileKey()));
      }
      catch(Exception e)
      {
         response.setFailure(e);
         return false;
      }
      return true;
   }

   protected void doRollbackFromActive()
   {
      //
   }

   protected void doRollbackFromCancelled()
   {
      //
   }

   protected void doRollbackFromComplete()
   {
      //
   }

   protected void doRollbackFromPrepared()
   {
      // FIXME, do we have to start that stuff again ?
   }

   protected void doRollbackFromRollbackOnly()
   {
      // FIXME       
   }

}

