/*
* JBoss, Home of Professional Open Source
* Copyright 2009, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.plugins.management;

import java.util.Set;

import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.NameMatcher;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.NoSuchDeploymentException;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public class ManagementViewWrapper implements ManagementView
{

   /** The mgtView runtime permission. */
   private static RuntimePermission MV_RUNTIME_PERMISSION = new RuntimePermission(ManagementView.class.getName());
   
   /** The delegate. */
   private final ManagementView delegate;

   public ManagementViewWrapper(ManagementView view)
   {
      if(view == null)
      {
         throw new IllegalArgumentException("null delegate view");
      }
      this.delegate = view;
   }

   @Override
   public void applyTemplate(String deploymentBaseName, DeploymentTemplateInfo info) throws Exception
   {
      getDelegateView().applyTemplate(deploymentBaseName, info);
   }

   @Override
   public ManagedComponent getComponent(String name, ComponentType type) throws Exception
   {
      return getDelegateView().getComponent(name, type);
   }

   @Override
   public Set<ComponentType> getComponentTypes()
   {
      return getDelegateView().getComponentTypes();
   }

   @Override
   public Set<ManagedComponent> getComponentsForType(ComponentType type) throws Exception
   {
      return getDelegateView().getComponentsForType(type);
   }

   @Override
   public ManagedDeployment getDeployment(String name) throws NoSuchDeploymentException
   {
      return getDelegateView().getDeployment(name);
   }

   @Override
   public Set<String> getDeploymentNames()
   {
      return getDelegateView().getDeploymentNames();
   }

   @Override
   public Set<String> getDeploymentNamesForType(String type)
   {
      return getDelegateView().getDeploymentNamesForType(type);
   }

   @Override
   public Set<ManagedDeployment> getDeploymentsForType(String type) throws Exception
   {
      return getDelegateView().getDeploymentsForType(type);
   }

   @Override
   public Set<ManagedComponent> getMatchingComponents(String name, ComponentType type,
         NameMatcher<ManagedComponent> matcher) throws Exception
   {
      return getDelegateView().getMatchingComponents(name, type, matcher);
   }

   @Override
   public Set<String> getMatchingDeploymentName(String regex) throws NoSuchDeploymentException
   {
      return getDelegateView().getMatchingDeploymentName(regex);
   }

   @Override
   public Set<ManagedDeployment> getMatchingDeployments(String name, NameMatcher<ManagedDeployment> matcher)
         throws NoSuchDeploymentException, Exception
   {
      return getDelegateView().getMatchingDeployments(name, matcher);
   }

   @Override
   public DeploymentTemplateInfo getTemplate(String name) throws NoSuchDeploymentException
   {
      return getDelegateView().getTemplate(name);
   }

   @Override
   public Set<String> getTemplateNames()
   {
      return getDelegateView().getTemplateNames();
   }

   @Override
   public boolean load()
   {
      return getDelegateView().load();
   }

   @SuppressWarnings("deprecation")
   public void process() throws Exception
   {
      getDelegateView().process();
   }

   @SuppressWarnings("deprecation")
   public void reload()
   {
      getDelegateView().reload();
   }

   @Override
   public void removeComponent(ManagedComponent comp) throws Exception
   {
      getDelegateView().removeComponent(comp);
   }

   @Override
   public void updateComponent(ManagedComponent comp) throws Exception
   {
      getDelegateView().updateComponent(comp);
   }
   
   ManagementView getDelegateView()
   {
      checkPermission();
      if(this.delegate == null)
      {
         throw new IllegalStateException("null delegate view");
      }
      return this.delegate;
   }
   
   void checkPermission()
   {
      SecurityManager sm = System.getSecurityManager();
      if(sm != null)
      {
         sm.checkPermission(MV_RUNTIME_PERMISSION);
      }
   }
   
}

