/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.plugins.management.actions;

import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.management.actions.AbstractTwoPhaseModificationAction;
import org.jboss.profileservice.persistence.repository.PersistenceRepository;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.management.ManagementAction;
import org.jboss.profileservice.spi.action.management.ManagementActionContext;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public class RemoveComponentAction extends AbstractTwoPhaseModificationAction<ManagementActionContext> implements ManagementAction<ManagementActionContext>
{
   
   /** The component. */
   private ManagedComponent component;
   
   /** The persistence repository. */
   private PersistenceRepository persistenceRepository;
   
   public RemoveComponentAction(ManagedComponent component, PersistenceRepository persistenceRepository,
         ManagementActionContext modificationContext)
   {
      super(modificationContext);
      this.component = component;
      this.persistenceRepository = persistenceRepository;
   }

   protected void doCancel()
   {
      
   }

   protected void doCommit(ProfileModificationResponse response)
   {
      
   }

   protected void doComplete(ProfileModificationResponse response) throws Exception
   {
      
   }

   protected boolean doPrepare(ProfileModificationResponse response)
   {
      try
      {
         // TODO fail if not supported 
         if(persistenceRepository.isSupportPersistence(component))
         {
            ManagedDeployment deployment = component.getDeployment();
            persistenceRepository.removeComponent(deployment.getName(), component);
         }
      }
      catch(Exception e)
      {
         response.setFailure(e);
         return false;
      }
      return true;
   }

   protected void doRollbackFromActive()
   {
      
   }

   protected void doRollbackFromCancelled()
   {

   }

   protected void doRollbackFromComplete()
   {
      
   }

   protected void doRollbackFromPrepared()
   {
     
   }

   protected void doRollbackFromRollbackOnly()
   {
      
   }

}

