/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.plugins.management.actions;

import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ActivationPolicy;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.profileservice.management.actions.AbstractTwoPhaseModificationAction;
import org.jboss.profileservice.persistence.repository.PersistenceRepository;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.management.ManagementAction;
import org.jboss.profileservice.spi.action.management.ManagementActionContext;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public class UpdateComponentAction extends AbstractTwoPhaseModificationAction<ManagementActionContext> implements ManagementAction<ManagementActionContext>
{

   private ManagedComponent updatedComponent;
   private ManagedComponent serverComponent;
   private AbstractManagementProxyFactory proxyFactory;
   private PersistenceRepository persistenceRepository;
   
   public UpdateComponentAction(ManagedComponent updatedComponent, ManagedComponent serverComponent,
         AbstractManagementProxyFactory proxyFactory,
         PersistenceRepository persistenceRepository,
         ManagementActionContext modificationContext)
   {
      super(modificationContext);
      this.updatedComponent = updatedComponent;
      this.serverComponent = serverComponent;
      this.persistenceRepository = persistenceRepository;
      this.proxyFactory = proxyFactory;
   }

   protected void doCancel()
   {
      // FIXME doCancel
      
   }

   protected void doCommit(ProfileModificationResponse response)
   {
      // FIXME doCommit
      
   }

   protected void doComplete(ProfileModificationResponse response) throws Exception
   {
      // FIXME doComplete
      
   }

   protected boolean doPrepare(ProfileModificationResponse response)
   {
      try
      {
         // Dispatch any runtime component property values
         for(ManagedProperty prop : updatedComponent.getProperties().values())
         {
            // Skip null values && non-CONFIGURATION values, unmodified values, and removed values
            boolean skip = prop.getValue() == null
               || prop.isReadOnly()
               || prop.hasViewUse(ViewUse.CONFIGURATION) == false
//               || prop.isModified() == false
               || prop.isRemoved() == true;
            if( skip )
            {
               continue;
            }
            
            ManagedProperty ctxProp = serverComponent.getProperties().get(prop.getName());
            // Check for a mapped name
            if( ctxProp == null )
            {
               String mappedName = prop.getMappedName();
               if( mappedName != null )
                  ctxProp = serverComponent.getProperties().get(mappedName);
            }
            if( ctxProp == null )
            {
               throw new IllegalArgumentException("trying to update non existing property." + prop.getName());
            }
            // The property value must be a MetaValue
            Object value = prop.getValue();
            if ((value instanceof MetaValue) == false)
            {
               throw new IllegalArgumentException("invalid value for property " + prop.getName());
            }
            // Update the serverComp
            MetaValue metaValue = (MetaValue)value;
            ctxProp.setField(Fields.META_TYPE, metaValue.getMetaType());
            ctxProp.setValue(metaValue);

            // Dispatch any runtime component property values
            Object componentName = getComponentName(ctxProp);
            ActivationPolicy policy = ctxProp.getActivationPolicy();

            if (componentName != null && policy.equals(ActivationPolicy.IMMEDIATE))
            {
               getProxyFactory().getDispatcher().set(componentName, ctxProp, metaValue);
            }
         }
         // Persistence
         if(persistenceRepository.isSupportPersistence(serverComponent))
         {
            ManagedDeployment deployment = serverComponent.getDeployment();
            persistenceRepository.updateDeployment(deployment.getName(), serverComponent);
         }
      }
      catch(Throwable t)
      {
         response.setFailure(t);
         return false;
      }
      return true;
   }

   protected void doRollbackFromActive()
   {
      // FIXME doRollbackFromActive
      
   }

   protected void doRollbackFromCancelled()
   {
      // FIXME doRollbackFromCancelled
      
   }

   protected void doRollbackFromComplete()
   {
      // FIXME doRollbackFromComplete
      
   }

   protected void doRollbackFromPrepared()
   {
      // FIXME doRollbackFromPrepared
      
   }

   protected void doRollbackFromRollbackOnly()
   {
      // FIXME doRollbackFromRollbackOnly
      
   }

   protected AbstractManagementProxyFactory getProxyFactory()
   {
      return proxyFactory;
   }
   
   /**
    * Get the component name from managed property.
    *
    * @param property the managed property
    * @return component name or null if no coresponding component
    */
   protected Object getComponentName(ManagedProperty property)
   {
      // first check target
      ManagedObject targetObject = property.getTargetManagedObject();
      if (targetObject != null)
         return targetObject.getComponentName();

      // check owner
      targetObject = property.getManagedObject();
      return targetObject != null ? targetObject.getComponentName() : null;
   }

}

