/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.plugins.management.view;

import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ModificationEvent;
import org.jboss.profileservice.spi.action.ProfileModificationType;

/**
 * A view of an active <code>Profile</code> using <code>ProfileService</code>.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public class RegisteredProfileView extends AbstractProfileView
{

   /** The profile. */
   private final ProfileKey key;
   
   public RegisteredProfileView(ProfileKey key)
   {
      super();
      if(key == null)
      {
         throw new IllegalArgumentException("null profile key");
      }
      this.key = key;
   }

   public ProfileKey getKey()
   {
      return key;
   }
   
   @Override
   public void notify(final ModificationEvent event)
   {
      // TODO this should be more fine grained
      if(event.getModificationType() != ProfileModificationType.GET &&
            getKey().equals(event.getKey()))
      {
         markAsModified();
      }
   }
   
}

