/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.plugins.spi;

import org.jboss.managed.api.ManagedComponent;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface ProfileViewWrapper extends ProfileView
{

   /**
    * Set a common management proxy factory.
    * 
    * @param proxyFactory the proxy factory.
    */
   void setManagementProxyFactory(AbstractManagementProxyFactory proxyFactory);

   /**
    * Update the given component. This takes the component ManagedDeployment,
    * obtains the ManagedObject set for the underlying deployment, and applies
    * the component ManagedProperty set to matching the deployment ManagedObject
    * properties.
    * 
    * @param update the managed component update
    * @param original the managed component original
    * @throws Exception
    */
   void updateComponent(ManagedComponent update, ManagedComponent original)
      throws Exception;
   
   /**
    * Removes a given component. This will remove a component from the
    * associated ManagedDeployment.
    * 
    * @param update the managed component update
    * @param original the managed component original
    * @throws Exception
    */
   void removeComponent(ManagedComponent update, ManagedComponent original)
      throws Exception;
   
}

