/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.plugins.management.util;

import org.jboss.deployers.spi.management.ManagedComponentRuntimeDispatcher;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;

/**
 * The abstract managed proxy factory. A internal factory class
 * creating AOP proxies to allow runtime dispatching from the 
 * client.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public abstract class AbstractManagementProxyFactory
{

   /**
    * Get the runtime component dispatcher.
    * 
    * @return the runtime component dispatcher
    */
   public abstract ManagedComponentRuntimeDispatcher getDispatcher();
   
   /**
    * Create a proxy component.
    * 
    * @param delegate the delegate component
    * @return the proxy component
    */
   protected abstract ManagedComponent createComponentProxy(ManagedComponent delegate, Object componentName);
   
   /**
    * Create a proxy property.
    * 
    * @param delegate the delegate property
    * @return the proxy property
    */
   protected abstract ManagedProperty createPropertyProxy(ManagedProperty delegate, Object componentName);

   /**
    * Create a proxy operation.
    * 
    * @param delegate the delegate operation
    * @return the proxy operation
    */
   protected abstract ManagedOperation createOperationProxy(ManagedOperation delegate, Object componentName);
   
}

