/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.plugins.management.view;

import java.util.Collection;
import java.util.Set;

import org.jboss.deployers.spi.management.NameMatcher;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;
import org.jboss.profileservice.plugins.spi.ProfileView;
import org.jboss.profileservice.plugins.spi.ProfileViewWrapper;
import org.jboss.profileservice.spi.action.ModificationEvent;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public abstract class AbstractProfileViewWrapper implements ProfileViewWrapper
{

   /** The management proxy factory. */
   private AbstractManagementProxyFactory proxyFactory;

   /**
    * {@inheritDoc}
    */
   public abstract boolean load();
   
   /**
    * Get the delegate.
    * 
    * @return the delegate profile view
    */
   protected abstract ProfileView getDelegate();
   
   /**
    * Get the management proxy factory.
    * 
    * @return the proxy factory.
    */
   public AbstractManagementProxyFactory getProxyFactory()
   {
      return proxyFactory;
   }

   /**
    * {@inheritDoc}
    */
   public void setManagementProxyFactory(AbstractManagementProxyFactory proxyFactory)
   {
      this.proxyFactory = proxyFactory;
   }
   
   /**
    * {@inheritDoc}
    */
   public ManagedComponent getComponent(String name, ComponentType type)
   {
      return getDelegate().getComponent(name, type);
   }

   /**
    * {@inheritDoc}
    */
   public Set<ManagedComponent> getComponentsForType(ComponentType type)
   {
      return getDelegate().getComponentsForType(type);
   }

   /**
    * {@inheritDoc}
    */
   public Set<ComponentType> getComponentTypes()
   {
      return getDelegate().getComponentTypes();
   }

   /**
    * {@inheritDoc}
    */
   public Collection<String> getDeploymentNames()
   {
      return getDelegate().getDeploymentNames();
   }

   /**
    * {@inheritDoc}
    */
   public Set<String> getDeploymentNamesForType(String type)
   {
      return getDelegate().getDeploymentNamesForType(type);
   }

   /**
    * {@inheritDoc}
    */
   public Set<ManagedDeployment> getDeploymentsForType(String type)
   {
      return getDelegate().getDeploymentsForType(type);
   }

   /**
    * {@inheritDoc}
    */
   public ManagedDeployment getManagedDeployment(String name)
   {
      return getDelegate().getManagedDeployment(name);
   }

   /**
    * {@inheritDoc}
    */
   public Set<ManagedComponent> getMatchingComponents(String name, ComponentType type,
         NameMatcher<ManagedComponent> matcher)
   {
      return getDelegate().getMatchingComponents(name, type, matcher);
   }

   /**
    * {@inheritDoc}
    */
   public Set<String> getMatchingDeploymentName(String regex)
   {
      return getDelegate().getMatchingDeploymentName(regex);
   }

   /**
    * {@inheritDoc}
    */
   public Set<ManagedDeployment> getMatchingDeployments(String name, NameMatcher<ManagedDeployment> matcher)
   {
      return getDelegate().getMatchingDeployments(name, matcher);
   }

   /**
    * {@inheritDoc}
    */
   public void notify(ModificationEvent event)
   {
      getDelegate().notify(event);
   }
   
}

