/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.plugins.spi;

import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;

/**
 * The management deployment processing context.
 * 
 * We are going to update the deployers integration to support
 * a visitor pattern to build the server-side view of MOs in future.
 * This will likely be similar, just based on a deployment level - 
 * not on the whole profile.
 * 
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface ProfileViewProcessingContext
{

   /**
    * Add a managed object.
    * 
    * @param managedObject the managed object
    */
   // TODO this cannot be really used for now.
   public void addManagedObject(ManagedObject managedObject);
   
   /**
    * Add a managed component.
    * 
    * @param component the managed component
    */
   public void addManagedComponent(ManagedComponent component);

   /**
    * Add a managed deployment.
    * 
    * @param deployment the managed deployment
    */
   public void addManagedDeployment(ManagedDeployment deployment);
   
}

